/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.dataimport;

import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BasePasswordField;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.gui.dataimport.DefaultDataImport;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDataImport
extends DefaultDataImport {
    protected List<BaseField> automaticFields;
    protected String oraclePort;
    private BaseField passwordField;
    private BaseField userNameField;
    private BasePasswordField password;
    private BaseTextField userName;
    private BaseField authenticationField;

    protected DatabaseDataImport(ImportEntryList entries) {
        super(entries);
    }

    @Override
    public List<BaseField> getAutomaticFields() {
        if (this.automaticFields == null) {
            this.automaticFields = new ArrayList<BaseField>();
            BaseComboBox type = new BaseComboBox(new Object[]{"ORACLE", "MSSQL"}, TextManager.instance().get("COMBO_BOX_DEFAULT_OPTION"));
            String strType = String.format(TextManager.instance().get("TYPE_DESCRIPTION"), "\n", "\n");
            BaseField typeField = new BaseField((BaseComponent)type, TextManager.instance().get("FIELD_DATABASE_TYPE"), true, strType);
            typeField.setTooltip(TextManager.instance().get("TYPE_DESCRIPTION"));
            typeField.setID("DBType");
            BaseComboBox authenticationDropdown = new BaseComboBox(new Object[]{"SQL Server Authentication", "Windows Authentication"}, TextManager.instance().get("COMBO_BOX_DEFAULT_OPTION"));
            String strAuthentication = String.format(TextManager.instance().get("AUTHENTICATION_DESCRIPTION"), "\n", "\n");
            this.authenticationField = new BaseField((BaseComponent)authenticationDropdown, TextManager.instance().get("FIELD_AUTHENTICATION_TYPE"), true, strAuthentication);
            this.authenticationField.setTooltip(TextManager.instance().get("AUTHENTICATION_DESCRIPTION"));
            this.authenticationField.setID("AuthenticationType");
            this.authenticationField.setEnabled(false);
            BaseTextField hostName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            BaseField hostNameField = new BaseField((BaseComponent)hostName, TextManager.instance().get("FIELD_HOST_NAME"), true, TextManager.instance().get("HOST_NAME_DESCRIPTION"));
            hostNameField.setTooltip(TextManager.instance().get("HOST_NAME_DESCRIPTION"));
            hostNameField.setID("HostName");
            this.userName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            this.userNameField = new BaseField((BaseComponent)this.userName, TextManager.instance().get("FIELD_USER_NAME"), true, TextManager.instance().get("USER_NAME_DESCRIPTION"));
            this.userNameField.setTooltip(TextManager.instance().get("USER_NAME_DESCRIPTION"));
            this.userNameField.setID("UserName");
            this.password = new BasePasswordField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            this.passwordField = new BaseField((BaseComponent)this.password, TextManager.instance().get("FIELD_PASSWORD"), true, TextManager.instance().get("PASSWORD_DESCRIPTION"));
            this.passwordField.setTooltip(TextManager.instance().get("PASSWORD_DESCRIPTION"));
            this.passwordField.setID("Password");
            BaseTextField port = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.IS_PORT));
            BaseField portField = new BaseField((BaseComponent)port, TextManager.instance().get("FIELD_PORT"), true, TextManager.instance().get("PORT_DESCRIPTION"));
            portField.setTooltip(TextManager.instance().get("PORT_DESCRIPTION"));
            portField.setID("DBPort");
            BaseTextField instanceName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            BaseField instanceNameField = new BaseField((BaseComponent)instanceName, TextManager.instance().get("FIELD_DATABASE_NAME"), true, TextManager.instance().get("DATA_SERVER_DESCRIPTION"));
            instanceNameField.setTooltip(TextManager.instance().get("DATA_SERVER_DESCRIPTION"));
            instanceNameField.setID("ServerName");
            BaseTextField schemaName = new BaseTextField();
            BaseField schemaNameField = new BaseField((BaseComponent)schemaName, TextManager.instance().get("FIELD_SCHEMA_NAME"), false, TextManager.instance().get("SCHEMA_DESCRIPTION"));
            schemaNameField.setTooltip(TextManager.instance().get("SCHEMA_DESCRIPTION"));
            schemaNameField.setID("SchemaName");
            type.addActionListener(e -> {
                String portStr = "";
                this.disableAuthenticationDropdown();
                this.enableUserNameAndPassword();
                if (port.getText().equals("1433") || this.oraclePort != null && !this.oraclePort.isEmpty()) {
                    portStr = this.oraclePort;
                }
                if (type.getSelectedIndex() == 0) {
                    instanceNameField.setTitle(TextManager.instance().get("FIELD_TIDAL_DATABASE_NAME"));
                    portStr = "";
                } else if (type.getSelectedIndex() == 1) {
                    instanceNameField.setTitle(TextManager.instance().get("FIELD_TIDAL_ORACLE_INTERFACE_NAME"));
                } else {
                    instanceNameField.setTitle(TextManager.instance().get("FIELD_TIDAL_MSSQL_INTERFACE_NAME"));
                    this.oraclePort = port.getText();
                    portStr = "1433";
                    if (authenticationDropdown.getSelectedItem().equals("Windows Authentication")) {
                        this.disableUserNameAndPassword();
                    }
                    this.enableAuthenticationDropdown(authenticationDropdown);
                }
                port.setText(portStr);
                if (!portStr.isEmpty()) {
                    port.getComponent().requestFocus();
                    type.getComponent().requestFocus();
                }
                if (hostName.getText() == null || hostName.getText().isEmpty()) {
                    hostName.setValidityLook(true);
                }
                if (this.isUserNameInvalid()) {
                    this.userName.setValidityLook(true);
                }
                if (this.isPasswordInvalid()) {
                    this.password.setValidityLook(true);
                }
                if (port.getText() == null || port.getText().isEmpty()) {
                    port.setValidityLook(true);
                }
                if (instanceName.getText() == null || instanceName.getText().isEmpty()) {
                    instanceName.setValidityLook(true);
                }
            });
            authenticationDropdown.addActionListener(e -> {
                this.enableUserNameAndPassword();
                if (authenticationDropdown.getSelectedItem().equals("Windows Authentication")) {
                    this.disableUserNameAndPassword();
                }
            });
            this.automaticFields.add(typeField);
            this.automaticFields.add(this.authenticationField);
            this.automaticFields.add(hostNameField);
            this.automaticFields.add(this.userNameField);
            this.automaticFields.add(this.passwordField);
            this.automaticFields.add(portField);
            this.automaticFields.add(instanceNameField);
            this.automaticFields.add(schemaNameField);
        }
        return this.automaticFields;
    }

    private boolean isPasswordInvalid() {
        return this.password.getText() == null || this.password.getText().isEmpty();
    }

    private boolean isUserNameInvalid() {
        return this.userName.getText() == null || this.userName.getText().isEmpty();
    }

    private void disableUserNameAndPassword() {
        this.passwordField.setEnabled(false);
        this.userNameField.setEnabled(false);
        this.userName.setValid(true);
        this.password.setValid(true);
    }

    private void enableUserNameAndPassword() {
        this.passwordField.setEnabled(true);
        this.userNameField.setEnabled(true);
        if (this.isPasswordInvalid()) {
            this.password.setValid(false);
        }
        if (this.isUserNameInvalid()) {
            this.userName.setValid(false);
        }
    }

    private void enableAuthenticationDropdown(BaseComboBox authenticationDropdown) {
        this.authenticationField.setEnabled(true);
        if (authenticationDropdown.getSelectedIndex() == 0) {
            this.authenticationField.setValid(false);
        }
    }

    private void disableAuthenticationDropdown() {
        this.authenticationField.setEnabled(false);
        this.authenticationField.setValid(true);
    }
}

