/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tester;

import com.bmc.ctmconvert.common.exceptions.ConversionException;
import com.bmc.ctmconvert.tester.ConditionTester;
import com.bmc.ctmconvert.tester.CreateFolderTester;
import com.bmc.ctmconvert.tester.CreateJobTester;
import com.bmc.ctmconvert.tester.FolderNameTester;
import com.bmc.ctmconvert.tester.JobNameTester;
import com.bmc.ctmconvert.tester.LinkFolderToFolderTester;
import com.bmc.ctmconvert.tester.LinkJobToFolderTester;
import com.bmc.ctmconvert.tester.RuleTester;
import org.json.JSONObject;

public class RuleTesterFactory {
    private JSONObject responseJson;
    private JSONObject requestJson;

    public RuleTesterFactory(JSONObject responseJson, JSONObject requestJson) {
        this.responseJson = responseJson;
        this.requestJson = requestJson;
    }

    public RuleTester createTesterFor() throws ConversionException {
        String ruleName;
        String nameArgument = "";
        switch (ruleName = this.requestJson.getString("testedRule")) {
            case "Create Folder": {
                return new CreateFolderTester(this.responseJson);
            }
            case "Folder Name": {
                nameArgument = this.requestJson.getString("argument1");
                return new FolderNameTester(this.responseJson, nameArgument);
            }
            case "Create Job": {
                return new CreateJobTester(this.responseJson);
            }
            case "Job Name": {
                nameArgument = this.requestJson.getString("argument1");
                return new JobNameTester(this.responseJson, nameArgument);
            }
            case "Link jobs to folders": {
                String jobNameArgument = this.requestJson.getString("argument1");
                String folderNameArgument = this.requestJson.getString("argument2");
                return new LinkJobToFolderTester(this.responseJson, jobNameArgument, folderNameArgument);
            }
            case "Link folders to folders": {
                String folder1Argument = this.requestJson.getString("argument1");
                String folder2Argument = this.requestJson.getString("argument2");
                return new LinkFolderToFolderTester(this.responseJson, folder1Argument, folder2Argument);
            }
            case "In Condition": {
                String entityNameArgument = this.requestJson.getString("argument1");
                String conditionArgument = this.requestJson.getString("argument2");
                return new ConditionTester(this.responseJson, entityNameArgument, conditionArgument, ConditionType.INCOND);
            }
            case "Out Condition": {
                String entityNameArgument = this.requestJson.getString("argument1");
                String conditionArgument = this.requestJson.getString("argument2");
                return new ConditionTester(this.responseJson, entityNameArgument, conditionArgument, ConditionType.OUTCOND);
            }
        }
        throw new ConversionException("Rule '" + ruleName + "' is not supported.");
    }

    public static enum ConditionType {
        INCOND("In Condition"),
        OUTCOND("Out Condition");

        private String name;

        private ConditionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

