/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tester;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.tester.RuleTester;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class LinkJobToFolderTester
implements RuleTester {
    private JSONObject responseJson;
    private String jobNameArgument;
    private String folderNameArgument;

    public LinkJobToFolderTester(JSONObject responseJson, String jobNameArgument, String folderNameArgument) {
        this.responseJson = responseJson;
        this.jobNameArgument = jobNameArgument;
        this.folderNameArgument = folderNameArgument;
    }

    @Override
    public void test() throws ConversionException {
        List createdFolders = Context.getWorkspace().getAllFolders();
        List<CtmFolder> folders = createdFolders.stream().filter(folder -> folder.getName().equals(this.folderNameArgument.trim())).collect(Collectors.toList());
        if (!this.isJobExistInOneOfTheFolders(folders)) {
            throw new ConversionException("When running 'Link jobs to folders' rule, job with name '" + this.jobNameArgument + "' was not created under folder name '" + this.folderNameArgument + "'.\r\n");
        }
        this.responseJson.put("message", (Object)("When running 'Link jobs to folders' rule, job with name '" + this.jobNameArgument + "' was created under folder name '" + this.folderNameArgument + "'.\r\n"));
    }

    private boolean isJobExistInOneOfTheFolders(List<CtmFolder> folders) {
        Predicate<IWorkspaceEntity> p1 = e -> ((CtmFolder)e).getChildren().stream().anyMatch(e1 -> e1.getName().equals(this.jobNameArgument.trim()) && e1 instanceof CtmJob);
        return folders.stream().anyMatch(p1);
    }
}

