/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tester;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.common.exceptions.ConversionException;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.tester.RuleTester;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class LinkFolderToFolderTester
implements RuleTester {
    private JSONObject responseJson;
    private String parentFolderArgument;
    private String subFolderArgument;

    public LinkFolderToFolderTester(JSONObject responseJson, String subFolderArgument, String parentFolderArgument) {
        this.responseJson = responseJson;
        this.subFolderArgument = subFolderArgument;
        this.parentFolderArgument = parentFolderArgument;
    }

    @Override
    public void test() throws ConversionException {
        List createdFolders = Context.getWorkspace().getAllFolders();
        List<CtmFolder> folders = createdFolders.stream().filter(folder -> folder.getName().equals(this.parentFolderArgument.trim())).collect(Collectors.toList());
        if (!this.isFolderExistInOneOfTheFolders(folders)) {
            throw new ConversionException("When running 'Link folders to folders' rule, sub folder with name '" + this.subFolderArgument + "' was not created under folder name '" + this.parentFolderArgument + "'.\r\n");
        }
        this.responseJson.put("message", (Object)("When running 'Link folders to folders' rule, sub folder with name '" + this.subFolderArgument + "' was created under folder name '" + this.parentFolderArgument + "'.\r\n"));
    }

    private boolean isFolderExistInOneOfTheFolders(List<CtmFolder> folders) {
        Predicate<IWorkspaceEntity> p1 = folder -> ((CtmFolder)folder).getChildren().stream().anyMatch(child -> child.getName().equals(this.subFolderArgument.trim()) && child instanceof CtmFolder);
        return folders.stream().anyMatch(p1);
    }
}

