/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CreateProjectServlet;
import com.bmc.ctmconvert.DeleteProjectServlet;
import com.bmc.ctmconvert.DeleteRuleServlet;
import com.bmc.ctmconvert.DoNewConvertServlet;
import com.bmc.ctmconvert.DoStopServer;
import com.bmc.ctmconvert.DuplicateProjectServlet;
import com.bmc.ctmconvert.EditProjectServlet;
import com.bmc.ctmconvert.ExportRuleServlet;
import com.bmc.ctmconvert.GetAllProjectsServlet;
import com.bmc.ctmconvert.GetAllRulesServlet;
import com.bmc.ctmconvert.GetFileContentServlet;
import com.bmc.ctmconvert.GetProjectDataFilesServlet;
import com.bmc.ctmconvert.GetSuppliedRulesListServlet;
import com.bmc.ctmconvert.ImportRulesServlet;
import com.bmc.ctmconvert.SaveRulesServlet;
import com.bmc.ctmconvert.TestRuleCompilationServlet;
import com.bmc.ctmconvert.TestRuleServlet;
import com.bmc.ctmconvert.UpdateProjectServlet;
import com.bmc.ctmconvert.common.Globs;
import java.io.IOException;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class SelfConversionServer {
    private static Server server;
    private int portNumber;
    private static int maximumPortTocheck;

    public void start(int port) throws Exception {
        this.portNumber = this.availablePort(port);
        server = this.getNewServer(this.portNumber);
        ResourceHandler resourceHandler = new ResourceHandler();
        String webDir = Globs.HOME_DIR + "\\SelfConversion\\dist\\";
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        resourceHandler.setResourceBase(webDir);
        ResourceHandler helpResourceHandler = new ResourceHandler();
        String helpDir = Globs.HOME_DIR + "\\data\\HelpFiles";
        helpResourceHandler.setDirectoriesListed(true);
        helpResourceHandler.setResourceBase(helpDir);
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath("/");
        contextHandler.addServlet(DoNewConvertServlet.class, "/doconvertNew");
        contextHandler.addServlet(GetSuppliedRulesListServlet.class, "/getPreDefinedRules");
        contextHandler.addServlet(DoStopServer.class, "/dostopserver");
        contextHandler.addServlet(CreateProjectServlet.class, "/createProject");
        contextHandler.addServlet(DuplicateProjectServlet.class, "/duplicateProject");
        contextHandler.addServlet(UpdateProjectServlet.class, "/updateProject");
        contextHandler.addServlet(GetFileContentServlet.class, "/getFileContent");
        contextHandler.addServlet(GetProjectDataFilesServlet.class, "/getProjectDataFiles");
        contextHandler.addServlet(GetAllProjectsServlet.class, "/getAllProjects");
        contextHandler.addServlet(GetAllRulesServlet.class, "/getAllRules");
        contextHandler.addServlet(SaveRulesServlet.class, "/saveRules");
        contextHandler.addServlet(DeleteProjectServlet.class, "/deleteProject");
        contextHandler.addServlet(DeleteRuleServlet.class, "/deleteRule");
        contextHandler.addServlet(ExportRuleServlet.class, "/exportRuleToPath");
        contextHandler.addServlet(EditProjectServlet.class, "/editProject");
        contextHandler.addServlet(TestRuleCompilationServlet.class, "/testRuleCompilation");
        contextHandler.addServlet(TestRuleServlet.class, "/testRule");
        contextHandler.addServlet(ImportRulesServlet.class, "/importRules");
        HandlerList handlersList = new HandlerList();
        handlersList.setHandlers(new Handler[]{resourceHandler, helpResourceHandler, contextHandler, new DefaultHandler()});
        server.setHandler((Handler)handlersList);
        server.start();
    }

    public Server getNewServer(int portNumber) {
        return new Server(portNumber);
    }

    public static Server getServer() {
        return server;
    }

    private int availablePort(int port) throws Exception {
        while (port < port + maximumPortTocheck) {
            if (!this.isPortInUse(port)) {
                return port;
            }
            ++port;
        }
        String errorMsg = String.format("There is no available port in the range (%s, %s)", port, maximumPortTocheck);
        throw new Exception(errorMsg);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    private boolean isPortInUse(int portNumber) {
        boolean bl;
        block8: {
            ServerSocket ignore = this.createServerSocket(portNumber);
            try {
                bl = false;
                if (ignore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return true;
                }
            }
            ignore.close();
        }
        return bl;
    }

    ServerSocket createServerSocket(int portNumber) throws IOException {
        return new ServerSocket(portNumber);
    }

    public void stop() {
        try {
            server.stop();
            System.out.println("Server Stopped");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        maximumPortTocheck = 10;
    }
}

