/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import javax.servlet.http.HttpServletResponse;

public class ResponseHandler {
    private HttpServletResponse response;

    public ResponseHandler(HttpServletResponse response) {
        this.response = response;
        this.initResponse();
    }

    private void initResponse() {
        this.response.setContentType("application/json");
        this.response.setStatus(200);
    }

    public void setSuccsedd(Path filePath, DataAccumulator dataAccumulator, String outputXmlString) throws IOException {
        String SuccseddJsonstring = this.getSucceseddedJsonContent(filePath, dataAccumulator, outputXmlString);
        this.setResponseMessage(SuccseddJsonstring);
    }

    private String getSucceseddedJsonContent(Path filePath, DataAccumulator dataAccumulator, String outputXml) {
        String status = "success";
        SuccessfulMessage succeseededMessage = new SuccessfulMessage(this, status);
        succeseededMessage.setDraftUrl("file:///" + filePath.toString());
        succeseededMessage.setOutputXml(outputXml);
        succeseededMessage.setTotalJobs(dataAccumulator.getCreatedJobsCount().toString());
        succeseededMessage.setTotalFolders(dataAccumulator.getCreatedFoldersCount().toString());
        succeseededMessage.setTotalSubs(dataAccumulator.getCreatedSubCount().toString());
        succeseededMessage.setTotalElements(Integer.toString(dataAccumulator.getCreatedSubCount() + dataAccumulator.getCreatedFoldersCount() + dataAccumulator.getCreatedJobsCount()));
        ObjectMapper mapper = new ObjectMapper();
        String jsonMessage = "";
        try {
            jsonMessage = mapper.writeValueAsString((Object)succeseededMessage);
        }
        catch (JsonProcessingException e1) {
            throw new RuntimeException(e1);
        }
        return jsonMessage;
    }

    public void setFailed(Exception e) throws IOException {
        String failedJsonString = this.getFailedJson(e);
        this.setResponseMessage(failedJsonString);
    }

    private String getFailedJson(Exception e) {
        String errMessage = e.getMessage();
        FailedMessage message = new FailedMessage(this, errMessage);
        ObjectMapper mapper = new ObjectMapper();
        String jsonMessage = "";
        try {
            jsonMessage = mapper.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e1) {
            throw new RuntimeException(e1);
        }
        return jsonMessage;
    }

    private void setResponseMessage(String jsonMessage) throws IOException {
        this.response.getWriter().println(jsonMessage);
    }

    public class SuccessfulMessage {
        private String status = "success";
        private String draftUrl;
        private String outputXml;
        private String totalJobs;
        private String totalFolders;
        private String totalSubs;
        private String totalElements;

        public String getDraftUrl() {
            return this.draftUrl;
        }

        public void setDraftUrl(String draftUrl) {
            this.draftUrl = draftUrl;
        }

        public String getOutputXml() {
            return this.outputXml;
        }

        public void setOutputXml(String outputXml) {
            this.outputXml = outputXml;
        }

        public String getTotalJobs() {
            return this.totalJobs;
        }

        public void setTotalJobs(String totalJobs) {
            this.totalJobs = totalJobs;
        }

        public String getTotalFolders() {
            return this.totalFolders;
        }

        public void setTotalFolders(String totalFolders) {
            this.totalFolders = totalFolders;
        }

        public String getTotalSubs() {
            return this.totalSubs;
        }

        public void setTotalSubs(String totalSubs) {
            this.totalSubs = totalSubs;
        }

        public String getTotalElements() {
            return this.totalElements;
        }

        public void setTotalElements(String totalElements) {
            this.totalElements = totalElements;
        }

        public SuccessfulMessage(ResponseHandler this$0, String status) {
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public class FailedMessage {
        private String errMessage;
        private String status;

        public FailedMessage(ResponseHandler this$0, String errMessage) {
            this.setErrMessage(errMessage);
            this.setStatus("failure");
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getErrMessage() {
            return this.errMessage;
        }

        public void setErrMessage(String errMessage) {
            this.errMessage = errMessage;
        }
    }
}

