/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OffsetHelper {
    private String offsetString;
    private static final String OPERATION_TAG = "OP1";
    private static final String OFFSET_TAG = "OFF1";
    private static final String SECOND_OFFSET_TAG = "OFF2";
    private static final String TYPE_TAG = "TYP1";
    private static final String EMPTY_STRING = "";
    private static final String NO_OFFSET = "NO_OFFSET";
    private Document document;

    public OffsetHelper(String offsetString) {
        this.offsetString = offsetString;
        this.parseOffset();
    }

    private void parseOffset() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = builder.newDocument();
            if (this.offsetString != null && !this.offsetString.isEmpty()) {
                this.document = builder.parse(new InputSource(new StringReader(this.offsetString)));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public boolean isEmpty() {
        return this.document.getChildNodes().getLength() == 0;
    }

    public OffsetOperation getOperation() {
        return OffsetOperation.toEnum(this.parseElementOrReturnDefaultValue(OPERATION_TAG, EMPTY_STRING));
    }

    private String parseElementOrReturnDefaultValue(String tagName, String defaultValue) {
        String value = defaultValue;
        NodeList elements = this.document.getElementsByTagName(tagName);
        if (elements.getLength() > 0) {
            value = elements.item(0).getTextContent();
        }
        return value;
    }

    public int getOffset() {
        int offset = 0;
        try {
            String offsetContent = this.parseElementOrReturnDefaultValue(OFFSET_TAG, EMPTY_STRING);
            if (!offsetContent.isEmpty()) {
                offset = Integer.parseInt(offsetContent);
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return offset;
    }

    public OffsetType getOffsetType() {
        return OffsetType.toEnum(this.parseElementOrReturnDefaultValue(TYPE_TAG, NO_OFFSET));
    }

    public boolean isOffsetSupported() {
        return this.isDaysOffsetOrEmptyOffset() && this.isSingleOffset();
    }

    private boolean isDaysOffsetOrEmptyOffset() {
        OffsetType offsetType = this.getOffsetType();
        return offsetType == OffsetType.DAYS || offsetType == OffsetType.NO_OFFSET;
    }

    private boolean isSingleOffset() {
        String secondOffset = this.parseElementOrReturnDefaultValue(SECOND_OFFSET_TAG, EMPTY_STRING);
        return secondOffset.isEmpty();
    }

    public boolean hasOffset() {
        return this.getOffset() != 0;
    }

    public static enum OffsetOperation {
        ADD(0),
        SUBTRACT(1),
        UNKNOWN(-1);

        private Integer value;

        private OffsetOperation(int value) {
            this.value = value;
        }

        public static OffsetOperation toEnum(String value) {
            OffsetOperation operation = UNKNOWN;
            for (OffsetOperation op : OffsetOperation.values()) {
                if (!op.value.toString().equals(value)) continue;
                operation = op;
            }
            return operation;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "+";
                }
                case 1: {
                    return "-";
                }
            }
            return "+";
        }
    }

    public static enum OffsetType {
        DAYS("DAYS"),
        MONTH("MONTH"),
        CMONTH("CMONTH"),
        CUSTCAL("CUSTCAL"),
        NO_OFFSET("NO_OFFSET"),
        UNKNOWN("UNKNOWN");

        private String value;

        private OffsetType(String value) {
            this.value = value;
        }

        public static OffsetType toEnum(String value) {
            OffsetType offsetType = UNKNOWN;
            for (OffsetType type : OffsetType.values()) {
                if (!type.value.equals(value)) continue;
                offsetType = type;
            }
            return offsetType;
        }
    }
}

