/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.sap;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class TidalSAPBWProcessChainConvertor
extends TidalXmlCmConvertor {
    private static Map<String, String> paramsToAutoeditsMap = new HashMap<String, String>();
    private String convertedJobMessageID = "WRN2324";
    private static final Set<String> suppressedElements = new HashSet<String>();

    public TidalSAPBWProcessChainConvertor() {
        this.applForm = "SAP Business Warehouse";
        this.applType = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_TYPE");
        this.applVer = (String)Globs.SAP_TYPE_FORM_VERSION.get("APPL_VER");
        this.cmVer = (String)Globs.SAP_TYPE_FORM_VERSION.get("CM_VER");
        this.autoeditToValue.put("%%SAPR3-PROCESS_TYPE", "ProcessChain");
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        return new HashSet<String>(suppressedElements);
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        HashMap<String, TidalXmlCmConvertor.NodeHandler> handledElementsMap = new HashMap<String, TidalXmlCmConvertor.NodeHandler>();
        handledElementsMap.put("text\\d+", this::handleTextNode);
        handledElementsMap.put("abap\\d+", this::handleABAPNode);
        return handledElementsMap;
    }

    private void handleTextNode(Node node) {
        String textContent = node.getTextContent();
        if (textContent != null && !textContent.isEmpty()) {
            this.autoeditToValue.put("%%SAPR3-ProcessChain_Desc", textContent);
        }
    }

    private void handleABAPNode(Node n) {
        this.autoeditToValue.put("%%SAPR3-ProcessChain_ID", n.getTextContent());
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        return new HashMap<String, String>(paramsToAutoeditsMap);
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        return new HashSet<Pair<String, String>>();
    }

    @Override
    protected String getJobConvertedSuccessMessageID() {
        return this.convertedJobMessageID;
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.autoeditToValue.put("%%SAPR3-ACCOUNT", "DEFAULT_CONNECTION");
        this.autoeditToValue.put("%%SAPR3-JOB_MODE", "PC_RUN_ORG");
    }

    static {
        suppressedElements.add("var.compound");
    }
}

