/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.ftp;

import com.bmc.ctmconvert.tidal.ftp.TidalFTPCommand;

public class TidalFTPParams {
    private TidalFTPCommand FTP_COMMAND = TidalFTPCommand.UNKNOWN;
    private String remoteHost = "";
    private String filename = "";
    private String newFilename = "";
    private boolean asciiTransferMode = true;
    private boolean isAnonymousFtp = false;
    private boolean replaceFileIfExists = false;
    private int commandInt;

    public TidalFTPParams(String ftpParameterString, String protocolInfo) {
        if (ftpParameterString != null && !ftpParameterString.isEmpty()) {
            String[] ftpParamsArray = ftpParameterString.split(",", 8);
            this.initParameters(ftpParamsArray);
        }
    }

    private void initParameters(String[] ftpParamsArray) {
        block11: for (int i = 0; i < ftpParamsArray.length; ++i) {
            switch (i) {
                case 0: {
                    try {
                        this.commandInt = Integer.parseInt(ftpParamsArray[i].trim());
                        this.FTP_COMMAND = TidalFTPCommand.enumFromInt(this.commandInt);
                    }
                    catch (NumberFormatException e) {}
                    continue block11;
                }
                case 1: {
                    this.remoteHost = ftpParamsArray[i].trim().replaceAll("^\"|\"$", "");
                    continue block11;
                }
                case 2: {
                    this.filename = ftpParamsArray[i].trim().replaceAll("^\"|\"$", "");
                    continue block11;
                }
                case 3: {
                    this.newFilename = ftpParamsArray[i].trim().replaceAll("^\"|\"$", "");
                    continue block11;
                }
                case 4: {
                    this.asciiTransferMode = ftpParamsArray[i].trim().equals("Y");
                    continue block11;
                }
                case 5: {
                    this.isAnonymousFtp = ftpParamsArray[i].trim().equals("Y");
                    continue block11;
                }
                case 6: {
                    this.replaceFileIfExists = ftpParamsArray[i].trim().equals("Y");
                    continue block11;
                }
                default: {
                    this.setDummyParams();
                }
            }
        }
    }

    public int getCommandInt() {
        return this.commandInt;
    }

    private void setDummyParams() {
        this.isAnonymousFtp = false;
        this.replaceFileIfExists = false;
        this.asciiTransferMode = true;
        this.filename = "";
        this.newFilename = "";
        this.remoteHost = "";
        this.FTP_COMMAND = TidalFTPCommand.UNKNOWN;
    }

    public TidalFTPCommand getFTP_COMMAND() {
        return this.FTP_COMMAND;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getNewFilename() {
        return this.newFilename;
    }

    public boolean isAsciiTransferMode() {
        return this.asciiTransferMode;
    }

    public boolean isAnonymous() {
        return this.isAnonymousFtp;
    }

    public boolean isReplaceFileIfExists() {
        return this.replaceFileIfExists;
    }
}

