/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.RecordsHolder;
import com.bmc.ctmconvert.tidal.TidalJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class TidalTimeZoneHandler {
    private RecordsHolder table_BIZUNIT;
    private Map<String, String> timeZoneMap;

    public TidalTimeZoneHandler(InputStream timeZoneMapperInputStream, RecordsHolder table_BIZUNIT) {
        this.setTimeZoneMap(timeZoneMapperInputStream);
        this.table_BIZUNIT = table_BIZUNIT;
    }

    private void setTimeZoneMap(InputStream timeZoneMapperInputStream) {
        this.timeZoneMap = new HashMap<String, String>();
        try (BufferedReader tidalTimeZoneReader = new BufferedReader(new InputStreamReader(timeZoneMapperInputStream));){
            String line;
            while ((line = tidalTimeZoneReader.readLine()) != null) {
                String[] params;
                if (line.startsWith("#") || line.isEmpty() || (params = line.split(",")).length != 2) continue;
                this.timeZoneMap.put(params[0].trim(), params[1].trim());
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public String getControlMTimeZone(TidalJob tidalJob, String timeZoneID) {
        IAttrHolder tzRecord = this.table_BIZUNIT.get(Integer.valueOf(timeZoneID).intValue());
        if (tzRecord != null) {
            String tidaltimezone = tzRecord.getAttr("BIZUNIT_TZID");
            String ctmTimeZone = this.timeZoneMap.get(tidaltimezone);
            if (ctmTimeZone == null || ctmTimeZone.equals("")) {
                tidalJob.addMessage("WRN2340", tidalJob.getOriginalJobName(), tidaltimezone, "Tidal2CtmTimeZones.txt");
                return "";
            }
            return ctmTimeZone;
        }
        return "";
    }
}

