/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tidal.TidalOEBSConvertor;
import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TidalOEBSSingleRequestConvertor
extends TidalOEBSConvertor {
    public TidalOEBSSingleRequestConvertor(String jobdtl_extinfo, String user) {
        this.paramsToAutoeditsMap.put("user_cp_rs_name", "%%OAP-PROGDESP");
        this.paramsToAutoeditsMap.put("cp_rs_name", "%%OAP-PROGNAME");
        this.paramsToAutoeditsMap.put("nls_lang", "%%OAP-LANGUAGE");
        this.paramsToAutoeditsMap.put("printer", "%%OAP-PRINTERS-P001-NAME");
        this.paramsToAutoeditsMap.put("number_copies", "%%OAP-PRINTERS-P001-VALUE");
        this.paramsToAutoeditsMap.put("print_style", "%%OAP-PRINTSTYLE");
        this.paramsToAutoeditsMap.put("appl_name", "%%OAP-APPDESP");
        this.paramsToAutoeditsMap.put("cp_rs_appl_short_name", "%%OAP-RESPAPP");
        this.autoeditToValue.put("%%OAP-USERNAME", user);
        XmlElement xmlRootElement = XmlLoader.from((String)jobdtl_extinfo);
        this.setSingleRequset(xmlRootElement);
    }

    private void setSingleRequset(XmlElement oebsJobDefinition) {
        this.setOEBSAppName(oebsJobDefinition);
        List requests = oebsJobDefinition.getAllDecnedElementByName("request");
        if (requests.size() != 0) {
            XmlElement request = (XmlElement)requests.get(0);
            this.setOEBSAppName(request);
            String operatingUnit = request.getValueOfFirstChildElementByName("operating_unit");
            if (!operatingUnit.isEmpty()) {
                this.autoeditToValue.put("%%OAP-HAS_OPERATING_UNIT", "Y");
                this.autoeditToValue.put("%%OAP-OPERATING_UNIT", operatingUnit);
            } else {
                this.autoeditToValue.put("%%OAP-HAS_OPERATING_UNIT", "N");
            }
            XmlElement parameters = request.getFirstChildElementByName("parameters");
            if (parameters != null) {
                this.setParamsForSingleRequest(parameters);
            }
        }
    }

    private void setOEBSAppName(XmlElement oebsJobDefinition) {
        String topLevelAppName = oebsJobDefinition.getValueOfFirstChildElementByName("cp_rs_appl_short_name");
        this.autoeditToValue.put("%%OAP-APPNAME", topLevelAppName);
    }

    private void setParamsForSingleRequest(XmlElement parameterTable) {
        List allParameters = parameterTable.getAllDecnedElementByName("param");
        int paramNumber = 1;
        for (XmlElement xmlElement : allParameters) {
            String name = xmlElement.getValueOfFirstChildElementByName("end_user_colname");
            String value = xmlElement.getValueOfFirstChildElementByName("value");
            this.autoeditToValue.put(String.format("%%%%OAP-PARMS-P%03d-NAME", paramNumber), name);
            this.autoeditToValue.put(String.format("%%%%OAP-PARMS-P%03d-VALUE", paramNumber), value);
            this.autoeditToValue.put(String.format("%%%%OAP-PARMS-P%03d-VALSETTYP", paramNumber), "N");
            ++paramNumber;
        }
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        return new HashMap<String, String>(this.paramsToAutoeditsMap);
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        HashMap<String, TidalXmlCmConvertor.NodeHandler> ElementHandlerMap = new HashMap<String, TidalXmlCmConvertor.NodeHandler>(this.getCommonElementHandlerMap());
        ElementHandlerMap.put("nls_lang", null);
        ElementHandlerMap.put("printer", null);
        ElementHandlerMap.put("number_copies", null);
        ElementHandlerMap.put("print_style", null);
        ElementHandlerMap.put("appl_name", null);
        ElementHandlerMap.put("cp_rs_appl_short_name", null);
        ElementHandlerMap.put("user_cp_rs_name", null);
        ElementHandlerMap.put("cp_rs_name", null);
        return ElementHandlerMap;
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        Set<Pair<String, String>> MandatoryAutoeditsList = this.getCommonMandatoryAutoeditsList();
        MandatoryAutoeditsList.add((Pair<String, String>)new Pair((Object)"%%OAP-PROGDESP", (Object)"user_cp_rs_name"));
        MandatoryAutoeditsList.add((Pair<String, String>)new Pair((Object)"%%OAP-PROGNAME", (Object)"cp_rs_name"));
        return MandatoryAutoeditsList;
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.setCommonDefaultAutoeditValues();
        this.autoeditToValue.put("%%OAP-TASKTYPE", "REQUEST");
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        return new HashSet<String>(this.getCommonSuppresedElements());
    }
}

