/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.AutoEditsConcatenator;
import com.bmc.ctmconvert.common.CommandToEmbeddedTransformer;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.NonQuotedStringReplacer;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.ctmutilities.event.ConditionCommandBuilder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message.MessageRegistry;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tidal.CalcTimeFromTo;
import com.bmc.ctmconvert.tidal.CyclicJobData;
import com.bmc.ctmconvert.tidal.HandleEnvFileVariable;
import com.bmc.ctmconvert.tidal.JobDep;
import com.bmc.ctmconvert.tidal.JobDepList;
import com.bmc.ctmconvert.tidal.JobDepTable;
import com.bmc.ctmconvert.tidal.Jobmst;
import com.bmc.ctmconvert.tidal.MessageReporter;
import com.bmc.ctmconvert.tidal.NodeGroupsTable;
import com.bmc.ctmconvert.tidal.NodesTable;
import com.bmc.ctmconvert.tidal.RbcRetriever;
import com.bmc.ctmconvert.tidal.TidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalDefs;
import com.bmc.ctmconvert.tidal.TidalResolveJobOwner;
import com.bmc.ctmconvert.tidal.TidalTimeZoneHandler;
import com.bmc.ctmconvert.tidal.VarMstTable;
import com.bmc.ctmconvert.tidal.nodegroup.NodeGroup;
import com.bmc.ctmconvert.tidal.utils.ConvertDateUtils;
import com.bmc.ctmconvert.tidal.variables.Variable;
import com.bmc.ctmconvert.tidal.variables.VariableClassifier;
import com.bmc.ctmconvert.tidal.variables.VariableFactory;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TidalJob
implements SchedEntity {
    private static final String ECHO_NO_COMMAND_LINE = "Echo no command line";
    public static final String SPECIAL_MARKER = "bmcSpecialMarker";
    private final TidalDefs m_sourceDefs;
    private RulesDataSet m_rules = null;
    private IAttrHolder m_jobdtl_rec = null;
    private IAttrHolder m_jobmst_rec = null;
    private IAttrHolder m_owner_rec = null;
    private TidalJob m_parent = null;
    private SchedEntity.TYPE m_type;
    private boolean m_OsWindows = false;
    private String m_nodegrp = "";
    private boolean m_isValid = true;
    private int m_id;
    private String m_jobName = "";
    private String m_origJobName = "";
    private String m_tableName = "";
    private String m_owner = "";
    private String m_application = null;
    private String m_author = null;
    private String m_group = null;
    private String m_description = null;
    private String m_timeFrom = null;
    private String m_timeTo = null;
    private String m_dateFrom = null;
    private String m_dateTo = null;
    private String m_priority = null;
    private String m_taskType = null;
    private String m_origTaskType = "";
    private CyclicJobData cyclicJobData;
    private boolean isActiveEntity = false;
    private String m_memname = null;
    private String m_memlib = null;
    private String m_overlib = null;
    private final LinkedHashMap<String, String> m_jobAutoedits = new LinkedHashMap();
    private List<Properties> tags = null;
    private ArrayList<String> m_messages = null;
    private final List<String> m_optionalAttr = new ArrayList<String>();
    private final HashMap<String, String> resolvedParams = new HashMap();
    private List<SchedEntity> children = null;
    private String m_useJcl = null;
    private String m_instreamJcl = null;
    private String m_originalJobDtlParams = null;
    private boolean convertedToEmbedded = false;
    private Map<String, String> attributes;

    public static TidalJob createTidalJob(String tableName, IAttrHolder attributes, SourceDefinitions sourceDef, RulesDataSet rules) {
        TidalJob tidalJob = new TidalJob(tableName, attributes, sourceDef);
        tidalJob.init(rules);
        return tidalJob;
    }

    public static TidalJob createTidalJob(TidalJob parent, IAttrHolder jobmst_record, SourceDefinitions sourceDef, RulesDataSet rules) {
        try {
            TidalJob tidalJob = new TidalJob(parent, jobmst_record, sourceDef);
            tidalJob.init(rules);
            return tidalJob;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Job: " + jobmst_record.getAttr("JOBMST_NAME"), ex);
        }
    }

    public TidalJob(String tableName, IAttrHolder attributesHolder, SourceDefinitions sourceDef) {
        this.m_sourceDefs = (TidalDefs)sourceDef;
        this.m_tableName = tableName.isEmpty() ? null : FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", tableName);
        this.setValid(true);
        this.m_jobmst_rec = attributesHolder;
        this.attributes = new HashMap<String, String>();
        this.m_messages = new ArrayList();
    }

    public TidalJob(TidalJob parent, IAttrHolder jobmst_record, SourceDefinitions sourceDef) {
        this.m_sourceDefs = (TidalDefs)sourceDef;
        this.m_parent = parent;
        this.m_jobmst_rec = jobmst_record;
        this.attributes = new HashMap<String, String>();
        this.m_messages = new ArrayList();
    }

    void init(RulesDataSet rules) {
        this.m_rules = rules;
        this.m_id = this.m_jobmst_rec.getAttrAsInt("JOBMST_ID");
        this.m_origJobName = this.getOriginalJobName();
        MessageReporter messageReporter = new MessageReporter(this.m_messages, this.m_origJobName, this.getJobname4Report());
        this.determineType();
        this.m_jobName = this.validateJobName();
        this.initRelatedRecords();
        this.cyclicJobData = new CyclicJobData(messageReporter, this.m_jobdtl_rec, this.type());
        this.validateJob();
        if (!this.isValid()) {
            return;
        }
        this.determineJobOwner();
        this.determineRuningPlatform();
        String active = this.m_jobmst_rec.getAttr("JOBMST_ACTIVE");
        if (active.equalsIgnoreCase("Y")) {
            this.isActiveEntity = true;
        } else if (this.type() != SchedEntity.TYPE.SMART_TABLE) {
            Reporter.addMessage(this.m_messages, (String)"INF2002", (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName});
        }
        if (this.m_type == SchedEntity.TYPE.JOB) {
            if (this.isAdapterJob()) {
                TidalCmConvertor cmConvertor = this.m_sourceDefs.getCmManager().getConvertor(this);
                cmConvertor.convertCmValues(this.m_jobdtl_rec);
                this.m_taskType = "Job";
                cmConvertor.convert(this);
            } else if (this.isTaskTypeJob() && this.toTaskTypeJob()) {
                this.m_taskType = "Job";
            } else {
                this.m_taskType = "Command";
                boolean toEmbeddedIfLong = this.m_rules.getBooleanRule("TaskType", new String[]{"ConvertLongCmdToEmbedded"});
                if (toEmbeddedIfLong && this.calculateCmdString().length() > 512) {
                    this.m_origTaskType = this.m_taskType = "Job";
                    this.handleLongCmdToEmbedded();
                    this.convertedToEmbedded = true;
                }
            }
            this.m_origTaskType = this.m_taskType;
            if (this.m_rules.getTaskTypeHandler().isToDummy()) {
                if (!Params.instance().getGUIVersion().equals("7")) {
                    this.m_jobAutoedits.put("%%$BMCWAIORIGTYPE", this.m_taskType);
                }
                this.m_taskType = "Dummy";
            }
        }
        this.convertTimeZone();
        String outputFileName = this.m_jobdtl_rec.getAttr("JOBDTL_OUTPUTNAME");
        if (outputFileName != null && !outputFileName.isEmpty()) {
            if (outputFileName.matches(".*<.+>.*")) {
                String resolvedOutputFileName = this.expandAutoedits(outputFileName);
                if (resolvedOutputFileName.matches(".*<.+>.*")) {
                    Reporter.addMessage(this.m_messages, (String)"WRN2307", (String)this.getJobname4Report(), (String[])new String[]{outputFileName});
                }
                outputFileName = resolvedOutputFileName;
            }
            String postCommand = this.m_OsWindows ? "type " : "cat ";
            this.m_jobAutoedits.put("%%POSTCMD", this.expandAutoedits(postCommand + outputFileName));
        }
        TidalJobType jobMSTType = this.getJobMSTType();
        if (this.m_type != SchedEntity.TYPE.TABLE && jobMSTType != TidalJobType.JOB_TYPE_FTPJOB) {
            this.createJobAutoedits();
        }
        this.getTags();
        this.m_dateFrom = this.convertActivePeriod(this.m_jobdtl_rec.getAttr("JOBDTL_FROMDT"));
        this.m_dateTo = this.convertActivePeriod(this.m_jobdtl_rec.getAttr("JOBDTL_UNTILDT"));
        switch (this.type()) {
            case SMART_TABLE: 
            case SUB_TABLE: {
                this.getTimeFrom();
                this.getTimeTo();
                break;
            }
        }
        this.m_description = this.applyFieldConversion("DESCRIPTION");
        this.m_author = this.applyFieldConversion("AUTHOR");
        if (this.m_parent == null) {
            this.m_application = FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.getApplication(), true, "OWNER_NAME", this.getJobname4Report(), this.m_messages);
            this.m_group = FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.getGroup(), true, "OWNER_NAME", this.getJobname4Report(), this.m_messages);
        } else {
            this.m_application = FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.m_parent.getApplication(), true, "OWNER_NAME", this.getJobname4Report(), this.m_messages);
            this.m_group = FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.m_parent.getGroup(), true, "OWNER_NAME", this.getJobname4Report(), this.m_messages);
        }
        this.cyclicJobData.reportUnsupportedRepeatingJobGroup(this.getJobName());
    }

    private String convertActivePeriod(String period) {
        Function<LocalDate, String> convertToString = date -> String.format("%4d%02d%02d", date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        return Optional.ofNullable(ConvertDateUtils.tryConvertDate(period)).map(convertToString).orElse("");
    }

    private void convertTimeZone() {
        String timezone;
        TidalTimeZoneHandler timezoneConvertor = this.m_sourceDefs.getTimeZoneConvertor();
        String tidalTimeZoneID = this.m_jobmst_rec.getAttr("BIZUNIT_ID");
        if (tidalTimeZoneID != null && !tidalTimeZoneID.isEmpty() && !(timezone = timezoneConvertor.getControlMTimeZone(this, tidalTimeZoneID)).isEmpty()) {
            this.attributes.put("TIMEZONE", timezone);
        }
    }

    public boolean isAdapterJob() {
        return this.m_sourceDefs.getCmManager().isAdapterJob(this.m_id);
    }

    private String validateJobName() {
        boolean isJob;
        boolean bl = isJob = this.m_type == SchedEntity.TYPE.JOB;
        if (isJob) {
            return FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.m_origJobName, true, "JOBMST_NAME", this.getJobname4Report(), this.m_messages);
        }
        return FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.m_origJobName, true, "JOBMST_NAME", this.getJobname4Report(), this.m_messages);
    }

    private void validateJob() {
        if (!this.canParentJobContainChildren()) {
            this.setValid(false);
            Reporter.addMessage(this.m_messages, (String)"ERR2601", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName, this.m_parent.getJobName(), this.m_parent.getJobMSTType().name()});
        }
    }

    private boolean canParentJobContainChildren() {
        if (!this.isChildJob()) {
            return true;
        }
        return this.m_parent.canContainChildren();
    }

    private boolean isChildJob() {
        return this.m_parent != null;
    }

    public String applyFieldConversion(String field) {
        return this.m_rules.getFieldEditor().generateCTMField(field, this::getFieldValueFromCompetitorField);
    }

    private String getFieldValueFromCompetitorField(String competitorField) {
        if (competitorField.equalsIgnoreCase("JOBMST_NAME") || competitorField.equalsIgnoreCase("JOBMST_ID") || competitorField.equalsIgnoreCase("JOBMST_RUNBOOK") || competitorField.equalsIgnoreCase("JOBMST_DESC")) {
            return this.m_jobmst_rec.getAttr(competitorField);
        }
        IAttrHolder tmp_usrmst_rec = null;
        int userID = this.m_jobdtl_rec.getAttrAsInt("JOBDTL_PROXY");
        if (userID != 0) {
            tmp_usrmst_rec = this.m_sourceDefs.getRecordByID("USRMST", userID);
        }
        if (competitorField.equalsIgnoreCase("OWNER_NAME")) {
            return this.m_owner_rec.getAttr("OWNER_NAME");
        }
        if (competitorField.equalsIgnoreCase("USRMST_NAME")) {
            if (tmp_usrmst_rec != null) {
                return tmp_usrmst_rec.getAttr("USRMST_NAME");
            }
        } else if (competitorField.equalsIgnoreCase("USRMST_FULLNAME")) {
            if (tmp_usrmst_rec != null) {
                return tmp_usrmst_rec.getAttr("USRMST_FULLNAME");
            }
        } else if (competitorField.equalsIgnoreCase("USRMST_DESC") && tmp_usrmst_rec != null) {
            return tmp_usrmst_rec.getAttr("USRMST_DESC");
        }
        return "";
    }

    private void reportSourceDefsMessages(List<List<String>> messages) {
        for (List<String> message : messages) {
            if (message.isEmpty()) continue;
            if (message.size() > 1) {
                String msgID = message.removeFirst();
                if (!msgID.equals("INF0013") && !msgID.equals("INF0014")) {
                    message.addFirst(this.m_origJobName);
                }
                String[] messageArr = message.toArray(new String[0]);
                Reporter.addMessage(this.m_messages, (String)msgID, (String)this.getJobname4Report(), (String[])messageArr);
                continue;
            }
            Reporter.addMessage(this.m_messages, (String)message.getFirst(), (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName});
        }
    }

    private void determineJobOwner() {
        TidalResolveJobOwner jobOwnerResolver = new TidalResolveJobOwner(this.m_sourceDefs, this.m_jobdtl_rec, this.m_owner_rec, this.m_OsWindows, this.m_origJobName, this.m_jobmst_rec, this);
        jobOwnerResolver.resolveJobOwner();
        this.m_owner = jobOwnerResolver.getJobOwner();
    }

    void initRelatedRecords() {
        int m_jobdtl_id = this.m_jobmst_rec.getAttrAsInt("JOBDTL_ID");
        this.m_jobdtl_rec = this.m_sourceDefs.getRecordByID("JOBDTL", m_jobdtl_id);
        if (this.m_jobdtl_rec == null) {
            this.setValid(false);
            Reporter.addMessage(this.m_messages, (String)"ERR2600", (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName});
            return;
        }
        boolean useJobMstVars = this.type() != SchedEntity.TYPE.JOB && this.m_jobmst_rec.isFieldExist("JOBMST_VARS");
        this.m_originalJobDtlParams = useJobMstVars ? this.m_jobmst_rec.getAttr("JOBMST_VARS") : this.m_jobdtl_rec.getAttr("JOBDTL_PARAMS");
        if (this.m_originalJobDtlParams == null) {
            this.m_originalJobDtlParams = "";
        }
        int m_owner_id = this.m_jobmst_rec.getAttrAsInt("JOBMST_OWNER");
        this.m_owner_rec = this.m_sourceDefs.getRecordByID("OWNER", m_owner_id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAttr(String attrName) {
        String ret = null;
        if (attrName.equalsIgnoreCase("PARENT_TABLE") || attrName.equalsIgnoreCase("TABLE_NAME")) {
            String tableName = this.getTableName();
            return FieldValidation.instance().validateAndReturnFixedValue(attrName, tableName, true, null, this.getJobname4Report(), this.m_messages);
        }
        if (attrName.equalsIgnoreCase("OWNER")) {
            this.m_owner = FieldValidation.instance().validateAndReturnFixedValue(attrName, this.m_owner, true, "JOBMST_OWNER", this.getJobname4Report(), this.m_messages);
            return this.m_owner;
        }
        if (!attrName.equalsIgnoreCase("APPLICATION")) {
            if (attrName.equalsIgnoreCase("TABLE_USERDAILY")) {
                if (!this.isValid()) return "";
                if (this.isConvertInactiveAndInactiveSmart()) return "";
                if (!this.isUnScheduled()) return "SYSTEM";
                return "";
            }
            if (attrName.equalsIgnoreCase("AUTHOR")) {
                this.m_author = this.getAuthor();
                this.m_author = FieldValidation.instance().validateAndReturnFixedValue(attrName, this.m_author, true, null, this.getJobname4Report(), this.m_messages);
                return this.m_author;
            }
            if (attrName.equalsIgnoreCase("GROUP")) {
                if (!this.m_group.isEmpty()) return this.m_group;
                Reporter.addMessage(this.m_messages, (String)"INF2022", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName});
                return this.m_group;
            }
            if (attrName.equalsIgnoreCase("JOBNAME")) {
                return this.getJobName();
            }
            if (attrName.equalsIgnoreCase("DESCRIPTION")) {
                String desc = this.getDescription();
                this.m_description = FieldValidation.instance().validateAndReturnFixedValue(attrName, desc, true, "JOBMST_DESCJOBMST_RUNBOOK", this.getJobname4Report(), this.m_messages);
                return this.m_description;
            }
            if (attrName.equalsIgnoreCase("TIMEFROM")) {
                return this.getTimeFrom();
            }
            if (attrName.equalsIgnoreCase("TIMETO")) {
                return this.getTimeTo();
            }
            if (attrName.equalsIgnoreCase("PRIORITY")) {
                return this.getPriority();
            }
            if (attrName.equalsIgnoreCase("CMDLINE")) {
                if (!this.m_origTaskType.equals("Command")) return "";
                String string = this.cmdLine();
                return string;
            }
            if (attrName.equalsIgnoreCase("NODEID")) {
                if (!this.m_nodegrp.isEmpty()) return this.m_nodegrp;
                if (this.m_parent == null) return this.m_nodegrp;
                this.m_nodegrp = this.m_parent.getNodeid();
                return this.m_nodegrp;
            }
            if (attrName.equalsIgnoreCase("CYCLIC")) {
                return this.cyclicJobData.handleCyclicAttribute();
            }
            if (attrName.compareTo("INTERVAL") == 0) {
                return this.cyclicJobData.cyclicIntervalsStr;
            }
            if (attrName.equalsIgnoreCase("CYCLIC_TYPE")) {
                return this.cyclicJobData.cyclicType;
            }
            if (attrName.equalsIgnoreCase("CYCLIC_TIMES_SEQUENCE")) {
                return this.cyclicJobData.cyclicTimeSequences;
            }
            if (attrName.equalsIgnoreCase("MAXRERUN")) {
                return String.valueOf(this.cyclicJobData.maxReruns);
            }
            if (attrName.equalsIgnoreCase("TASKTYPE")) {
                return this.m_taskType;
            }
            if (attrName.compareTo("MEMNAME") == 0) {
                return this.m_memname;
            }
            if (attrName.compareTo("MEMLIB") == 0) {
                return this.m_memlib;
            }
            if (attrName.compareTo("OVERLIB") == 0) {
                return this.m_overlib;
            }
            if (attrName.equalsIgnoreCase("TAG_RELATIONSHIP")) {
                if (this.isActiveEntity) return "OR";
                if (this.type() != SchedEntity.TYPE.JOB) return "AND";
                if (!this.isUnScheduled()) return "AND";
                return "OR";
            }
            if (attrName.equalsIgnoreCase("ACTIVE_FROM")) {
                if (this.m_dateFrom == null) return "";
                return this.m_dateFrom;
            }
            if (attrName.equalsIgnoreCase("ACTIVE_TILL")) {
                if (this.m_dateTo == null) return "";
                return this.m_dateTo;
            }
            if (attrName.equalsIgnoreCase("IND_CYCLIC")) {
                return "START";
            }
            if (attrName.equalsIgnoreCase("INSTREAM_JCL")) {
                return this.m_instreamJcl;
            }
            if (attrName.equalsIgnoreCase("USE_INSTREAM_JCL")) {
                return this.m_useJcl;
            }
            if (!this.attributes.containsKey(attrName)) return ret;
            return this.attributes.get(attrName);
        }
        if (!this.m_application.isEmpty()) return this.m_application;
        Reporter.addMessage(this.m_messages, (String)"INF2021", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName});
        return ret;
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
    }

    public String getApplication() {
        if (this.m_application != null) {
            return this.m_application;
        }
        String application = "";
        if (this.m_owner_rec != null) {
            application = this.m_owner_rec.getAttr("OWNER_NAME");
        }
        return application;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public List<SchedEntity> getChildren() {
        if (this.children == null) {
            AttrHolderList jobmstRecsList = Jobmst.instance().getChilds(this.m_id);
            if (jobmstRecsList == null) {
                return null;
            }
            this.children = new ArrayList<SchedEntity>();
            for (IAttrHolder cur_jobmst : jobmstRecsList) {
                this.children.add(TidalJob.createTidalJob(this, cur_jobmst, (SourceDefinitions)this.m_sourceDefs, this.m_rules));
            }
        }
        return this.children;
    }

    boolean canContainChildren() {
        return this.isTidalJobTypeGroup(this.getJobMSTType());
    }

    private TidalJobType getJobMSTType() {
        Integer jobMSTType = this.m_jobmst_rec.getAttrAsInt("JOBMST_TYPE");
        return TidalJobType.toEnum(jobMSTType);
    }

    private boolean isTidalJobTypeGroup(TidalJobType jobType) {
        return jobType == TidalJobType.JOB_TYPE_GROUP;
    }

    public List<Properties> getInConds() {
        List<Properties> inconds = this.m_sourceDefs.getJobInconds(this);
        Iterator<Properties> it = inconds.iterator();
        this.checkInCondLogicAndReport();
        while (it.hasNext()) {
            Properties incond = it.next();
            String name = incond.getProperty("NAME");
            String newIncondName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", name);
            if (newIncondName.compareTo(name) == 0) continue;
            incond.remove("NAME");
            incond.put("NAME", newIncondName);
        }
        return inconds;
    }

    private void checkInCondLogicAndReport() {
        boolean isUnknownOperator;
        String AND = "1";
        String OR = "2";
        String logicOperator = this.m_jobdtl_rec.getAttr("JOBDTL_DEPLOGIC");
        boolean bl = isUnknownOperator = logicOperator != null && !logicOperator.equals(AND) && !logicOperator.equals(OR);
        if (isUnknownOperator) {
            Reporter.addMessage(this.m_messages, (String)"WRN2331", (String)this.getJobname4Report(), (String[])new String[]{this.getJobName(), logicOperator});
        }
    }

    public int getJobID() {
        return this.m_id;
    }

    public String getJobName() {
        return this.m_jobName;
    }

    public List<Properties> getOnStmt() {
        return this.m_sourceDefs.getJobOnstmts(this);
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getOutConds() {
        List<Properties> outconds = this.m_sourceDefs.getJobOutconds(this);
        for (Properties outcond : outconds) {
            String name = outcond.getProperty("NAME");
            String newOutcondName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", name);
            if (newOutcondName.compareTo(name) == 0) continue;
            outcond.remove("NAME");
            outcond.put("NAME", newOutcondName);
        }
        return outconds;
    }

    public String getParentName() {
        if (this.m_parent == null) {
            return "";
        }
        String grandParent = this.m_parent.getParentName();
        if (grandParent == null) {
            grandParent = "";
        }
        return grandParent + (grandParent.isEmpty() ? "" : "/") + this.m_parent.getJobName();
    }

    public SchedEntity getParent() {
        return this.m_parent;
    }

    public String getTableName() {
        String res = this.m_parent == null ? (this.m_tableName != null ? this.m_tableName : this.m_jobName) : this.m_parent.getTablePathForSons();
        return res;
    }

    public String getTablePathForSons() {
        Object tablePathForSons = this.m_parent == null ? this.m_jobName : this.m_parent.getTablePathForSons() + "/" + this.m_jobName;
        return tablePathForSons;
    }

    public List<Properties> getTags() {
        if (this.tags == null) {
            this.tags = this.getUnsortedTags();
            this.tags.sort(this.compareByTagName());
        }
        return this.tags;
    }

    private Comparator<? super Properties> compareByTagName() {
        return Comparator.comparing(o -> o.getProperty("NAME"));
    }

    private List<Properties> getUnsortedTags() {
        RbcRetriever retriever = new RbcRetriever(this.m_sourceDefs.getTableByName("EVNTMST"), this.m_sourceDefs.getTableByName("JOBMST"), this.m_sourceDefs.getTableByName("JOBDTL"), this.m_sourceDefs.getTableByName("EVNTYEAR"), this.m_sourceDefs.getTableByName("EVNTCHLD"), this.m_sourceDefs.getTableByName("EVNTCOND"), Jobmst.instance()::getChilds);
        Set<RBC> retSet = retriever.getRbcsFor(this.m_id);
        return retSet.stream().map(RBC::getRawRbc).collect(Collectors.toList());
    }

    private boolean isConvertInactiveAndInactiveSmart() {
        boolean isIgnoreInactiveJobs = RuleManager.instance().getCurrentRules().getBooleanRule("Additional Tidal rules", new String[]{"IGNORE_INACTIVE"});
        boolean inactiveEntity = !isIgnoreInactiveJobs && !this.isActiveEntity;
        return inactiveEntity && this.type() == SchedEntity.TYPE.SMART_TABLE;
    }

    private boolean isUnScheduled() {
        int eventId = this.m_jobmst_rec.getAttrAsInt("EVNTMST_ID");
        boolean noSchedule = eventId == 0;
        String isInhertiedString = this.m_jobdtl_rec.getAttr("JOBDTL_INHEVENT");
        boolean isInhertiedScheduling = isInhertiedString != null && isInhertiedString.equals("Y");
        return noSchedule && !isInhertiedScheduling;
    }

    public boolean isCyclic() {
        try {
            return this.cyclicJobData.isCyclic || this.getAttr("CYCLIC").equals("1");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed handle Cyclic Attribute for job " + this.m_jobName, e);
        }
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    private void setValid(boolean isValid) {
        this.m_isValid = isValid;
    }

    public String originalProductID() {
        return null;
    }

    public SchedEntity.TYPE type() {
        return this.m_type;
    }

    private void determineType() {
        String jobmst_type = this.m_jobmst_rec.getAttr("JOBMST_TYPE");
        this.m_type = this.m_parent == null ? (this.m_tableName != null ? SchedEntity.TYPE.JOB : SchedEntity.TYPE.SMART_TABLE) : (jobmst_type.equalsIgnoreCase("1") ? SchedEntity.TYPE.SUB_TABLE : SchedEntity.TYPE.JOB);
    }

    public String getAuthor() {
        return this.m_author;
    }

    public String getGroup() {
        if (this.m_application != null) {
            return this.m_application;
        }
        String group = "";
        if (this.m_owner_rec != null) {
            group = this.m_owner_rec.getAttr("OWNER_NAME");
        }
        return group;
    }

    private String getDescription() {
        return this.m_description;
    }

    public String getTimeFrom() {
        CalcTimeFromTo calcTimeFromTo = new CalcTimeFromTo(this.m_timeFrom, this.m_jobdtl_rec, this.m_parent, this.m_messages, this.getJobname4Report(), this.m_origJobName, this.m_jobName);
        this.m_timeFrom = calcTimeFromTo.getTimeFrom();
        return this.m_timeFrom;
    }

    public String getTimeTo() {
        CalcTimeFromTo calcTimeFromTo = new CalcTimeFromTo(this.m_timeTo, this.m_jobdtl_rec, this.m_parent, this.m_messages, this.getJobname4Report(), this.m_origJobName, this.m_jobName);
        this.m_timeTo = calcTimeFromTo.getTimeTo();
        return this.m_timeTo;
    }

    public String getPriority() {
        if (this.m_priority != null) {
            return this.m_priority;
        }
        int priority = this.m_jobdtl_rec.getAttrAsInt("JOBDTL_PRIORITY");
        this.m_priority = this.m_sourceDefs.getPriority(priority);
        return this.m_priority;
    }

    private void handleLongCmdToEmbedded() {
        String cmdline = this.calculateCmdString();
        boolean toEmbeddedIfLong = this.m_rules.getBooleanRule("TaskType", new String[]{"ConvertLongCmdToEmbedded"});
        if (toEmbeddedIfLong && cmdline.length() > 512) {
            CommandToEmbeddedTransformer transformer = new CommandToEmbeddedTransformer();
            this.m_instreamJcl = transformer.cmdlineToEmbeddedString(cmdline, this.m_OsWindows);
            this.m_useJcl = "Y";
            this.m_memname = "script.bat";
            Reporter.addMessage(this.m_messages, (String)"INF0022", (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName});
        }
    }

    private String cmdLine() {
        String cmdline = this.calculateCmdString();
        ArrayList tmp_messages = new ArrayList();
        if (this.type().equals((Object)SchedEntity.TYPE.JOB)) {
            FieldValidation.instance().cmdLineValidateAndReportMessages(cmdline, this.getJobname4Report(), tmp_messages);
        }
        tmp_messages.stream().map(message -> message.replace("WRN1005", "WRN1004")).forEach(message -> this.m_messages.add((String)message));
        return cmdline;
    }

    private boolean containsTidalVar(String stringToCheck) {
        return stringToCheck != null && stringToCheck.matches(".*?<[^>]*?>.*?");
    }

    private synchronized String calculateCmdString() {
        String cmd;
        String workDirCmd;
        StringBuilder sb = new StringBuilder();
        String launchCondName = this.getLaunchCondName();
        if (launchCondName != null) {
            String conditionCommand = new ConditionCommandBuilder().setAddAction().setConditionName(launchCondName).build().toCommand();
            sb.append(conditionCommand);
            sb.append(this.cmdSep());
        }
        if ((workDirCmd = this.buildChangeDirCommand()) != null) {
            sb.append(workDirCmd);
        }
        if ((cmd = this.getOrigCmdLine()).isEmpty()) {
            cmd = ECHO_NO_COMMAND_LINE;
        }
        if (this.shouldBeQuoted(cmd)) {
            cmd = GlobalFunctions.AddQuotes((String)cmd);
        }
        sb.append(cmd);
        if (!cmd.isEmpty()) {
            String cmdLineParameters = this.replaceAllButQuoted(this.m_originalJobDtlParams, "(\\r?\\n)+", " ");
            HandleEnvFileVariable cmdParams = new HandleEnvFileVariable(sb, cmdLineParameters, this.m_jobdtl_rec, VarMstTable.instance(), this.runningOnWindows());
            sb = cmdParams.getUpdatedCommandLine();
        }
        return this.expandAutoedits(sb.toString());
    }

    private String getLaunchCondName() {
        JobDepList out_deps = JobDepTable.instance().getOutDeps(this.m_id);
        if (out_deps == null) {
            return null;
        }
        for (JobDep dep : out_deps) {
            if (dep.getJobDepType() != JobDep.JobDepType.LAUNCH) continue;
            return JobDepTable.instance().getCondName(dep);
        }
        return null;
    }

    private String cmdSep() {
        if (this.runningOnWindows()) {
            return "& ";
        }
        return "; ";
    }

    public boolean runningOnWindows() {
        return this.m_OsWindows;
    }

    private void determineRuningPlatform() {
        TidalJob job = this;
        IAttrHolder jobdtlRec = job.m_jobdtl_rec;
        try {
            while (jobdtlRec != null) {
                this.initNodeAndOS(jobdtlRec);
                if (!this.m_nodegrp.isEmpty() || (job = job.m_parent) == null) break;
                jobdtlRec = job.m_jobdtl_rec;
            }
            if (this.m_nodegrp.isEmpty() && this.type().equals((Object)SchedEntity.TYPE.JOB)) {
                Reporter.addMessage(this.m_messages, (String)"INF2003", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName});
            }
        }
        catch (AgentListNotFoundException e) {
            Reporter.addMessage(this.m_messages, (String)"WRN2314", (String)this.getJobname4Report(), (String[])new String[]{e.getAgentListId()});
        }
    }

    private void initNodeAndOS(IAttrHolder jobdtlRec) {
        this.initNodeIdNodemst(jobdtlRec);
        if (!this.m_nodegrp.isEmpty()) {
            return;
        }
        this.initNodeIdNodelstmst(jobdtlRec);
        if (!this.m_nodegrp.isEmpty()) {
            return;
        }
        String cmdline = this.getOrigCmdLine();
        if (cmdline == null || cmdline.isEmpty()) {
            return;
        }
        if (cmdline.length() < 2) {
            this.m_OsWindows = false;
            return;
        }
        this.m_OsWindows = cmdline.endsWith(".bat") || cmdline.endsWith(".exe") || cmdline.endsWith(".cmd") || cmdline.charAt(1) == ':' || cmdline.startsWith("\\");
    }

    private void initNodeIdNodelstmst(IAttrHolder jobdtlRec) {
        String nodegrp_keyname = NodeGroupsTable.instance().keyName();
        String keyval = jobdtlRec.getAttr(nodegrp_keyname);
        if (keyval != null && !keyval.isEmpty()) {
            int key = Integer.parseInt(keyval);
            NodeGroup nodegrpDetails = NodeGroupsTable.instance().get(key);
            if (nodegrpDetails != null) {
                this.m_nodegrp = nodegrpDetails.name();
                String validatedName = FieldValidation.instance().validateAndReturnFixedValue("NODEGRP", this.m_nodegrp);
                if (!this.m_nodegrp.equalsIgnoreCase(validatedName)) {
                    String msgID = this.m_nodegrp.length() != validatedName.length() ? "WRN2304" : "INF2030";
                    Reporter.addMessage(this.m_messages, (String)msgID, (String)this.getJobname4Report(), (String[])new String[]{this.getJobname4Report(), this.m_nodegrp, validatedName});
                    this.m_nodegrp = validatedName;
                }
                this.addNodeGroupAction(nodegrpDetails, validatedName);
                this.m_OsWindows = nodegrpDetails.isWindows();
            } else {
                throw new AgentListNotFoundException(keyval);
            }
        }
    }

    private void initNodeIdNodemst(IAttrHolder jobdtlRec) {
        String nodeid_keyname = NodesTable.instance().keyName();
        String keyval = jobdtlRec.getAttr(nodeid_keyname);
        NodesTable.Node nodeDetails = null;
        if (keyval != null && !keyval.isEmpty()) {
            int key = Integer.parseInt(keyval);
            nodeDetails = NodesTable.instance().get(key);
        }
        if (nodeDetails != null) {
            this.m_nodegrp = nodeDetails.fullName();
            String newName = FieldValidation.instance().validateAndReturnFixedValue("NODEID", this.m_nodegrp);
            if (!this.m_nodegrp.equalsIgnoreCase(newName) && this.type().equals((Object)SchedEntity.TYPE.JOB)) {
                Reporter.addMessage(this.m_messages, (String)"WRN0021", (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName, this.m_nodegrp});
            }
            this.m_OsWindows = nodeDetails.isWindows();
        }
    }

    private void addNodeGroupAction(NodeGroup nodegrpDetails, String validatedName) {
        if (nodegrpDetails.getMembers().isEmpty()) {
            this.reportEmptyAgentList(nodegrpDetails);
        } else {
            this.reportMissingMembers(nodegrpDetails);
            Reporter.addNodeGroupAction((String)validatedName, nodegrpDetails.getMembers(), (String)this.m_origJobName);
        }
    }

    private void reportEmptyAgentList(NodeGroup nodegrpDetails) {
        String name = nodegrpDetails.name();
        if (this.m_sourceDefs.getAgentListNames().contains(name)) {
            return;
        }
        this.m_sourceDefs.addAgentListNames(name);
        new MessageRegistry().addMessage("Agent List", "WRN2315", new String[]{name});
    }

    private void reportMissingMembers(NodeGroup nodegrpDetails) {
        Set<Integer> missingMembers = nodegrpDetails.getMissingMembers();
        for (Integer memberId : missingMembers) {
            Reporter.addMessage(this.m_messages, (String)"WRN2313", (String)this.getJobname4Report(), (String[])new String[]{nodegrpDetails.name(), memberId.toString()});
        }
    }

    public String getNodeid() {
        return this.m_nodegrp;
    }

    private String buildChangeDirCommand() {
        String workDir = this.m_jobdtl_rec.getAttr("JOBDTL_WORKDIR");
        if (workDir.isEmpty() || workDir.length() == 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Object changeDirCommand = "cd ";
        if (this.runningOnWindows()) {
            if (workDir.contains(":")) {
                changeDirCommand = (String)changeDirCommand + "/d ";
            } else if (workDir.startsWith("\\") || workDir.startsWith("\"\\")) {
                changeDirCommand = "pushd ";
            }
        }
        sb.append((String)changeDirCommand);
        if (this.shouldBeQuoted(workDir)) {
            sb.append(GlobalFunctions.AddQuotes((String)workDir));
        } else {
            sb.append(workDir);
        }
        sb.append(this.cmdSep());
        return sb.toString();
    }

    private boolean shouldBeQuoted(String pathString) {
        return !pathString.startsWith("\"") && pathString.contains(" ") && !this.containsTidalVar(pathString);
    }

    private String getOrigCmdLine() {
        return this.m_jobdtl_rec.getAttr("JOBDTL_CMD");
    }

    public List<AssistingJob> getAssistingJobs() {
        return this.m_sourceDefs.getAssistingJobs(this.m_id);
    }

    public List<Properties> getCtrlResources() {
        return new ArrayList<Properties>();
    }

    public List<Properties> getQuantResources() {
        ArrayList qrs = (ArrayList)this.m_sourceDefs.getQuantResources(this.m_id);
        if (qrs != null) {
            for (Properties qr : qrs) {
                this.addQRAction(qr);
            }
        }
        return qrs;
    }

    private void addQRAction(Properties qr) {
        String name = qr.getProperty("NAME");
        String quantity = qr.getProperty("QUANT");
        HashMap<String, Object> quantAction = new HashMap<String, Object>();
        quantAction.put("ACTENTTYPE", "QR");
        quantAction.put("JOBID", this.m_origJobName + " (" + this.m_id + ")");
        quantAction.put("ACTENTNAME", name);
        quantAction.put("ACTENTQTY", quantity);
        quantAction.put("ACTSTATUS", "0");
        Reporter.addAction(quantAction);
    }

    IAttrHolder getJobdtlRec() {
        return this.m_jobdtl_rec;
    }

    public boolean hasWarnings() {
        if (this.m_messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.m_messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.m_jobAutoedits;
    }

    public String getOriginalJobName() {
        return this.m_jobmst_rec.getAttr("JOBMST_NAME");
    }

    public List<Properties> getShouts() {
        return null;
    }

    public List<String> getOptionalAttributes() {
        return this.m_optionalAttr;
    }

    public ArrayList<String> getMessages() {
        return new ArrayList<String>(new HashSet<String>(this.m_messages));
    }

    public void addMessage(String msgId, String ... msgArgs) {
        Reporter.addMessage(this.m_messages, (String)msgId, (String)this.getJobname4Report(), (String[])msgArgs);
    }

    public boolean hasMessages() {
        List<List<String>> messages = this.m_sourceDefs.getMessages(this.m_id);
        if (messages != null && !messages.isEmpty()) {
            this.reportSourceDefsMessages(messages);
        }
        return !this.m_messages.isEmpty();
    }

    String getJobname4Report() {
        return this.m_origJobName + " (" + this.m_id + ")";
    }

    private void addOptionalAttr(String attrName) {
        if (!this.m_optionalAttr.contains(attrName)) {
            this.m_optionalAttr.add(attrName);
        }
    }

    private boolean isTaskTypeJob() {
        boolean ret = false;
        if (this.m_rules.getTaskTypeHandler().isToJobType()) {
            for (String taskTypeFilter : this.m_rules.getTaskTypeHandler().getTaskTypeFilters()) {
                if (taskTypeFilter == null || !this.getOrigCmdLine().contains(taskTypeFilter)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private boolean toTaskTypeJob() {
        if (this.m_memname != null && this.m_memlib != null) {
            return true;
        }
        int dirSep = this.runningOnWindows() ? 92 : 47;
        String cmdLine = this.getOrigCmdLine();
        if (cmdLine.indexOf(dirSep) < 0) {
            return false;
        }
        if (cmdLine.startsWith("\"") && cmdLine.endsWith("\"")) {
            cmdLine = cmdLine.substring(1, cmdLine.length() - 1);
        }
        this.m_memname = this.expandAutoedits(cmdLine.substring(cmdLine.lastIndexOf(dirSep) + 1).trim());
        if (!FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.m_memname).equals(this.m_memname)) {
            Reporter.addMessage(this.m_messages, (String)"INF2019", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName, this.m_memname});
            this.m_memname = "";
            return false;
        }
        this.m_memlib = this.expandAutoedits(cmdLine.substring(0, cmdLine.lastIndexOf(dirSep)).trim());
        if (!FieldValidation.instance().validateAndReturnFixedValue("MEMLIB", this.m_memlib).equals(this.m_memlib)) {
            Reporter.addMessage(this.m_messages, (String)"INF2020", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName, this.m_memlib});
            this.m_memlib = "";
            return false;
        }
        this.m_overlib = this.expandAutoedits(this.m_jobdtl_rec.getAttr("JOBDTL_WORKDIR").trim());
        if (!this.m_overlib.isEmpty()) {
            while (this.m_overlib.startsWith("\"")) {
                this.m_overlib = this.m_overlib.substring(1);
            }
            while (this.m_overlib.endsWith("\"")) {
                this.m_overlib = this.m_overlib.substring(0, this.m_overlib.length() - 1);
            }
        }
        if (!this.m_overlib.isEmpty()) {
            while (this.m_overlib.startsWith("\"")) {
                this.m_overlib = this.m_overlib.substring(1);
            }
            while (this.m_overlib.endsWith("\"")) {
                this.m_overlib = this.m_overlib.substring(0, this.m_overlib.length() - 1);
            }
        }
        if (!this.m_overlib.isEmpty()) {
            this.addOptionalAttr("OVERLIB");
        }
        return !this.m_memlib.isEmpty() && !this.m_memname.isEmpty();
    }

    boolean isAssignmentString(String input) {
        return input != null && input.matches("^[^=,\\r\\n]+=[^=,\\r\\n]*(,[^=,\\r\\n]+=[^=,\\r\\n]*)*");
    }

    private void createJobAutoedits() {
        boolean isAsignment;
        if (this.m_originalJobDtlParams.isEmpty()) {
            return;
        }
        int varCount = 0;
        String[] rawParams = this.handleVarsWithNewLines(this.m_originalJobDtlParams);
        boolean isAssignmentString = this.isAssignmentString(this.m_originalJobDtlParams);
        boolean bl = isAsignment = isAssignmentString && rawParams.length == 1;
        if (isAsignment) {
            String[] splitLine = this.m_originalJobDtlParams.split(",");
            for (int j = 0; j < splitLine.length; ++j) {
                boolean useJobMstVars;
                if (splitLine[j].startsWith("'") && splitLine[j].endsWith("'") || splitLine[j].startsWith("\"") && splitLine[j].endsWith("\"")) {
                    splitLine[j] = splitLine[j].substring(1, splitLine[j].length() - 1);
                }
                String varName = splitLine[j].substring(0, splitLine[j].indexOf(61));
                boolean bl2 = useJobMstVars = this.type() != SchedEntity.TYPE.JOB && this.m_jobmst_rec.isFieldExist("JOBMST_VARS");
                if (varName.indexOf(32) >= 0 && !useJobMstVars) {
                    isAsignment = false;
                    break;
                }
                String varVal = splitLine[j].substring(splitLine[j].indexOf(61) + 1);
                String validatedAutoeditName = FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", "%%" + varName.trim(), true, "Variable", this.getJobname4Report(), this.m_messages);
                this.m_jobAutoedits.put(validatedAutoeditName, this.expandAutoedits(varVal));
            }
        } else {
            for (String rawParam : rawParams) {
                if (this.convertedToEmbedded || this.m_taskType != null && this.m_taskType.equals("Command")) continue;
                ArrayList<String> lineArgs = this.handleVarNamesWithSpaces(rawParam);
                if (lineArgs == null) {
                    ConversionLogger.getLogger().warning(String.format("Failed to parse parameter: '%s', job: '%s'", rawParam, this.getJobName()));
                    continue;
                }
                for (String var : lineArgs) {
                    if (var == null || var.isEmpty()) continue;
                    var = var.replaceAll("(\"bmcSpecialMarker(<.*?>)bmcSpecialMarker\")", "$2");
                    String workingVar = this.expandAutoedits(var);
                    String validatedAutoeditName = FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", "%%PARM" + ++varCount, true, "Variable", this.getJobname4Report(), this.m_messages);
                    this.m_jobAutoedits.put(validatedAutoeditName, workingVar);
                }
            }
        }
    }

    private String[] handleVarsWithNewLines(String varsString) {
        String newLinesRegex = "[\r\n]+";
        String modifiedString = this.replaceAllButQuoted(varsString, "[\r\n]+", SPECIAL_MARKER);
        String splitString = SPECIAL_MARKER;
        if (!modifiedString.contains(SPECIAL_MARKER)) {
            splitString = "[\r\n]+";
        }
        return modifiedString.split(splitString);
    }

    private ArrayList<String> handleVarNamesWithSpaces(String parsedParams) {
        String regexToReplace = "(<.*?>)";
        String replacement = "\"bmcSpecialMarker$1bmcSpecialMarker\"";
        parsedParams = this.replaceAllButQuoted(parsedParams, regexToReplace, replacement);
        return GlobalFunctions.string2ArgArr((String)parsedParams, (boolean)this.runningOnWindows(), (boolean)true);
    }

    private String replaceAllButQuoted(String inutpString, String regexToReplace, String replacement) {
        return new NonQuotedStringReplacer().replaceAllButQuoted(inutpString, regexToReplace, replacement);
    }

    public String expandAutoedits(String workingVar) {
        Matcher matcher;
        Pattern p = Pattern.compile(".*(<([^>]+)>).*", 32);
        workingVar = this.concatAutoedits(workingVar);
        workingVar = this.m_sourceDefs.resolveSystemVariables(workingVar);
        while ((matcher = p.matcher(workingVar)).matches()) {
            String varName = matcher.group(2);
            Object autoeditName = "%%" + varName;
            if (varName.startsWith("Group.")) {
                autoeditName = "%%" + varName.substring(varName.indexOf(46) + 1);
                if (!this.isInheritedVar((String)autoeditName)) {
                    Reporter.addMessage(this.m_messages, (String)"WRN1006", (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName, varName, autoeditName});
                }
            } else if (varName.indexOf(46) > 0) {
                int intVal;
                try {
                    intVal = Integer.parseInt(varName.substring(varName.indexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    intVal = -1;
                    workingVar = this.resolveAdditionalVariables(workingVar, varName);
                }
                if (intVal >= 0) {
                    String autoeditValue = "VARIABLE_VALUE_NOT_FOUND";
                    IAttrHolder temp = this.m_sourceDefs.getRecordByID("VARMST", intVal);
                    if (temp != null) {
                        autoeditName = "%%" + temp.getAttr("VARMST_NAME");
                        autoeditValue = temp.getAttr("VARMST_VALUE");
                    } else {
                        autoeditName = "%%" + varName.substring(0, varName.indexOf(46));
                        Reporter.addMessage(this.m_messages, (String)"WRN2312", (String)this.getJobname4Report(), (String[])new String[]{this.getJobName(), varName});
                    }
                    autoeditName = FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", ((String)autoeditName).trim(), true, "Variable", this.getJobname4Report(), this.m_messages);
                    this.m_jobAutoedits.put((String)autoeditName, this.expandAutoedits(autoeditValue));
                }
            } else {
                Reporter.addMessage(this.m_messages, (String)"WRN1006", (String)this.getJobname4Report(), (String[])new String[]{this.m_origJobName, varName, autoeditName});
                ConversionLogger.getLogger().info("Un Expected Variable: " + varName + " was found.");
            }
            if (!workingVar.contains(matcher.group(1))) continue;
            autoeditName = FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", ((String)autoeditName).trim(), true, "Variable", this.getJobname4Report(), this.m_messages);
            workingVar = workingVar.replace(matcher.group(1), (CharSequence)autoeditName);
        }
        return workingVar;
    }

    private String concatAutoedits(String workingVar) {
        return new AutoEditsConcatenator(Pattern.compile("(<[^>]*?>)")).concat(workingVar);
    }

    private String resolveAdditionalVariables(String unresolved, String variableReference) {
        String replacementAutoedit;
        String resolved = unresolved;
        if (this.resolvedParams.containsKey(variableReference) && this.m_jobAutoedits.containsKey(replacementAutoedit = this.resolvedParams.get(variableReference))) {
            resolved = unresolved.replace("<" + variableReference + ">", replacementAutoedit);
            return resolved;
        }
        try {
            Variable variable = VariableFactory.makeVariable(variableReference, this.m_sourceDefs.getVariableNamer());
            LinkedHashMap<String, String> assistingAutoedits = variable.getAssistingAutoedits();
            this.m_jobAutoedits.putAll(assistingAutoedits);
            if (variable.isNotSupported()) {
                Reporter.addMessage(this.m_messages, (String)"WRN2311", (String)this.getJobname4Report(), (String[])new String[]{this.m_jobName, variableReference, variable.getReplacementAutoeditName(), variable.getReplacementAutoeditValue()});
            }
            resolved = unresolved.replace("<" + variableReference + ">", variable.getReplacementAutoeditName());
            this.resolvedParams.put(variableReference, variable.getReplacementAutoeditName());
        }
        catch (VariableClassifier.VariableIdNotFoundException e) {
            String variableName = variableReference;
            if (variableReference.indexOf(46) >= 0) {
                variableName = variableReference.substring(0, variableReference.indexOf(46));
            }
            String autoeditName = "%%" + variableName;
            String autoEditValidName = this.validateAutoeditName(autoeditName);
            this.m_jobAutoedits.put(autoEditValidName, "VARIABLE_VALUE_NOT_FOUND");
            Reporter.addMessage(this.m_messages, (String)"WRN2312", (String)this.getJobname4Report(), (String[])new String[]{this.getJobName(), variableReference});
            resolved = unresolved.replace("<" + variableReference + ">", autoEditValidName);
        }
        return resolved;
    }

    private String validateAutoeditName(String variableReference) {
        return FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", variableReference.trim(), true, "Variable", this.getJobname4Report(), this.m_messages);
    }

    protected boolean isInheritedVar(String varName) {
        return this.m_jobAutoedits.containsKey(varName) || this.m_parent != null && this.m_parent.isInheritedVar(varName);
    }

    public boolean isDSJob() {
        return true;
    }

    public String getOriginalJobData() {
        StringBuilder jobData = new StringBuilder();
        if (this.m_jobdtl_rec != null) {
            this.attrHolderToString(jobData, this.m_jobdtl_rec);
        }
        if (this.m_jobmst_rec != null) {
            this.attrHolderToString(jobData, this.m_jobmst_rec);
        }
        return jobData.toString();
    }

    private void attrHolderToString(StringBuilder jobData, IAttrHolder jobAttributes) {
        if (jobAttributes != null) {
            String[] header;
            for (String field : header = jobAttributes.getCsvHeader().split(",")) {
                String attr = jobAttributes.getAttr(field);
                if (attr == null || attr.trim().isEmpty()) continue;
                jobData.append(String.format("%-20s\t: %s%s", field, attr, "\r\n"));
            }
        }
    }

    public void addAutoEdits(String varName, String value) {
        this.addVariable(varName, value);
    }

    public void addVariable(String varName, String value) {
        String expendedValue = this.expandAutoedits(value);
        this.m_jobAutoedits.put(varName, expendedValue);
    }

    public void setAttribute(String attrName, String attrValue) {
        this.attributes.put(attrName, attrValue);
    }

    public static enum TidalJobType {
        JOB_TYPE_GROUP(1),
        JOB_TYPE_JOB(2),
        JOB_TYPE_SAPJOB(3),
        JOB_TYPE_PSJOB(4),
        JOB_TYPE_ORAJOB(5),
        JOB_TYPE_FTPJOB(6),
        JOB_TYPE_OS400JOB(7),
        JOB_TYPE_ADAPTER(8),
        JOB_TYPE_UNKNOWN(-1);

        private final Integer value;

        private TidalJobType(Integer value) {
            this.value = value;
        }

        public static TidalJobType toEnum(Integer value) {
            TidalJobType tidalJobType = JOB_TYPE_UNKNOWN;
            for (TidalJobType type : TidalJobType.values()) {
                if (!type.value.equals(value)) continue;
                tidalJobType = type;
            }
            return tidalJobType;
        }
    }

    private static class AgentListNotFoundException
    extends RuntimeException {
        private final String nodelstmstId;

        public AgentListNotFoundException(String nodlstmstId) {
            this.nodelstmstId = nodlstmstId;
        }

        public String getAgentListId() {
            return this.nodelstmstId;
        }
    }
}

