/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.db.DbSqlWrapper;
import com.bmc.ctmconvert.tidal.MssqlMap;
import com.bmc.ctmconvert.tidal.TidalJob;
import com.bmc.ctmconvert.tidal.TidalXmlCmConvertor;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class TidalDBMSSQLQueryConvertor
extends TidalXmlCmConvertor {
    private TidalJob job;
    private DbSqlWrapper dbSqlWrapper;

    public TidalDBMSSQLQueryConvertor(TidalJob job) {
        this.job = job;
        this.dbSqlWrapper = new DbSqlWrapper((SchedEntity)this.job);
    }

    @Override
    protected Map<String, String> getParamsToAutoeditsMap() {
        MssqlMap mssqlMap = new MssqlMap();
        return mssqlMap.getSQLQuerymap();
    }

    @Override
    protected Map<String, TidalXmlCmConvertor.NodeHandler> getElementsHandlerMap() {
        HashMap<String, TidalXmlCmConvertor.NodeHandler> handledElementsMap = new HashMap<String, TidalXmlCmConvertor.NodeHandler>();
        handledElementsMap.put("sql", this::handleSQLNode);
        return handledElementsMap;
    }

    @Override
    protected Set<String> getSuppresedElementsSet() {
        MssqlMap mssqlMap = new MssqlMap();
        return mssqlMap.getSuppresedElementsSetSQLQuery();
    }

    @Override
    protected String getJobConvertedSuccessMessageID() {
        return "";
    }

    @Override
    protected Set<Pair<String, String>> getMandatoryAutoeditsToReportStringsList() {
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        return result;
    }

    @Override
    protected void setDefaultAutoeditValues() {
        this.dbSqlWrapper.convertToDbSqlJob();
    }

    private void handleSQLNode(Node node) {
        if (node != null) {
            String sql = node.getTextContent();
            this.dbSqlWrapper.addSqlQuery(sql);
        }
    }

    @Override
    public void convert(TidalJob tidalJob) {
        super.convert(tidalJob);
        tidalJob.addMessage("WRN2335", "DB_DEFAULT_CONNECTION", this.ignoredElementsStringList.toString(), tidalJob.getOriginalJobName(), tidalJob.getJobName());
    }
}

