/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tidal.FilterDataProvider;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobmstFilter {
    private HashMap<Integer, AttrHolderList> src;
    private HashMap<Integer, IAttrHolder> filteredJobIdsToJobmstMap;
    private Map<Integer, AttrHolderList> filteredList;
    private RulesDataSet.FilterData filterHandler;
    private List<FilterDataProvider> providers;

    public JobmstFilter(HashMap<Integer, AttrHolderList> src, RulesDataSet.FilterData filterHandler, List<FilterDataProvider> providersList) {
        this.providers = providersList;
        this.src = src;
        this.filterHandler = filterHandler;
        if (!filterHandler.isEmptyFilter()) {
            this.filteredJobIdsToJobmstMap = this.filterJobIds();
            this.filteredList = this.filter();
        } else {
            this.filteredList = this.src;
        }
    }

    public HashMap<Integer, AttrHolderList> getFilteredParentMap() {
        HashMap<Integer, AttrHolderList> result = this.filteredList == null ? new HashMap<Integer, AttrHolderList>() : new HashMap<Integer, AttrHolderList>(this.filteredList);
        return result;
    }

    private HashMap<Integer, AttrHolderList> filter() {
        HashMap<Integer, AttrHolderList> result = new HashMap<Integer, AttrHolderList>();
        for (Integer currentFilteredJobId : this.filteredJobIdsToJobmstMap.keySet()) {
            IAttrHolder currentJobmst = this.filteredJobIdsToJobmstMap.get(currentFilteredJobId);
            int parentId = currentJobmst.getAttrAsInt("JOBMST_PRNTID");
            result = this.handleFilteredJobmst(result, currentFilteredJobId, currentJobmst, parentId);
        }
        return result;
    }

    private HashMap<Integer, AttrHolderList> handleFilteredJobmst(HashMap<Integer, AttrHolderList> result, Integer currentFilteredJobId, IAttrHolder currentJobmst, int parentId) {
        while (currentJobmst != null) {
            IAttrHolder parentJobmst;
            AttrHolderList parentChildren;
            if (this.src.containsKey(currentFilteredJobId)) {
                result.putAll(this.getEntireHierarchy(currentFilteredJobId));
            }
            if (!result.containsKey(parentId)) {
                result.put(parentId, new AttrHolderList());
            }
            if ((parentChildren = result.get(parentId)) != null && !parentChildren.contains((Object)currentJobmst)) {
                parentChildren.add((Object)currentJobmst);
            }
            if ((parentJobmst = this.getDetailsById(parentId)) != null) {
                currentJobmst = parentJobmst;
                parentId = parentJobmst.getAttrAsInt("JOBMST_PRNTID");
                continue;
            }
            currentJobmst = null;
        }
        return result;
    }

    private HashMap<Integer, AttrHolderList> getEntireHierarchy(int currentFilteredJobId) {
        HashMap<Integer, AttrHolderList> result = new HashMap<Integer, AttrHolderList>();
        AttrHolderList children = this.src.get(currentFilteredJobId);
        if (children != null && !children.isEmpty()) {
            result.put(currentFilteredJobId, children);
            for (IAttrHolder child : children) {
                int childID = child.getAttrAsInt("JOBMST_ID");
                result.putAll(this.getEntireHierarchy(childID));
            }
        }
        return result;
    }

    private IAttrHolder getDetailsById(int wantedId) {
        IAttrHolder result = null;
        for (Integer parentId : this.src.keySet()) {
            if (wantedId == parentId) continue;
            for (IAttrHolder currentJobmst : this.src.get(parentId)) {
                Integer currentJobmstId;
                if (currentJobmst == null || (currentJobmstId = currentJobmst.getAttrAsInt("JOBMST_ID")) != wantedId) continue;
                return currentJobmst;
            }
        }
        return result;
    }

    private HashMap<Integer, IAttrHolder> filterJobIds() {
        HashMap<Integer, IAttrHolder> result = new HashMap<Integer, IAttrHolder>();
        if (this.src != null) {
            for (Integer parentId : this.src.keySet()) {
                for (IAttrHolder child : this.src.get(parentId)) {
                    Integer jobmstId = child.getAttrAsInt("JOBMST_ID");
                    HashMap<String, String> filterDetails = this.getFilterDetails(jobmstId);
                    if (!this.filterHandler.isFilter(filterDetails)) continue;
                    result.put(jobmstId, child);
                }
            }
        }
        return result;
    }

    private HashMap<String, String> getFilterDetails(int jobmstId) {
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        for (FilterDataProvider provider : this.providers) {
            if (provider == null) continue;
            Pair entry = (Pair)provider.apply(jobmstId);
            String fieldName = (String)entry.getKey();
            String fieldValue = (String)entry.getValue();
            filterDetails.put(fieldName, fieldValue);
        }
        return filterDetails;
    }
}

