/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tidal.ConditionNameMaker;
import com.bmc.ctmconvert.tidal.JobDep;
import com.bmc.ctmconvert.tidal.JobDepList;
import com.bmc.ctmconvert.tidal.Jobmst;
import java.io.InputStream;
import java.util.HashMap;

public class JobDepTable
extends CsvFile {
    private HashMap<Integer, JobDepList> m_inConds = new HashMap();
    private HashMap<Integer, JobDepList> m_outConds = new HashMap();
    private static RulesDataSet m_rules;
    private static ConditionNameMaker conditionNameMaker;
    private static JobDepTable m_instance;

    public static JobDepTable instance() {
        if (m_instance == null) {
            throw new RuntimeException("JobDepTable instance invoked with no input stream");
        }
        return m_instance;
    }

    public static JobDepTable instance(InputStream depInStream, RulesDataSet rules) {
        m_rules = rules;
        if (m_instance == null) {
            conditionNameMaker = new ConditionNameMaker(m_rules);
            m_instance = new JobDepTable();
            m_instance.loadInternal(depInStream);
        }
        return m_instance;
    }

    public static void destroy() {
        m_instance = null;
    }

    public void loadInternal(InputStream depInStream) {
        this.load(depInStream);
    }

    private JobDepTable() {
    }

    public String getCondName(JobDep jobDep) {
        return conditionNameMaker.buildCondName(jobDep);
    }

    protected void handleRecord(IAttrHolder new_record, int record_number) {
        JobDep new_dep = new JobDep(new_record);
        Jobmst jobmst = Jobmst.instance();
        int owning_job = new_dep.ownerJobId();
        int job_depending_on = new_dep.dependencyJobId();
        if (!jobmst.isLoaded(owning_job) || new_dep.type() == 1 && !jobmst.isLoaded(job_depending_on)) {
            return;
        }
        this.handleInConditions(new_dep, owning_job);
        this.handleOutConditions(new_dep);
    }

    private void handleOutConditions(JobDep new_dep) {
        int type = new_dep.type();
        if (type == 1) {
            int job_depending_on = new_dep.dependencyJobId();
            JobDepList outCondslist = this.m_outConds.get(job_depending_on);
            if (outCondslist == null) {
                outCondslist = new JobDepList();
                this.m_outConds.put(job_depending_on, outCondslist);
                outCondslist.add(new_dep);
            } else if (!outCondslist.containsCondition(new_dep)) {
                outCondslist.add(new_dep);
            }
        }
    }

    private void handleInConditions(JobDep new_dep, int owning_job) {
        JobDepList inConditionslist = null;
        inConditionslist = this.m_inConds.get(owning_job);
        if (inConditionslist == null) {
            inConditionslist = new JobDepList();
            this.m_inConds.put(owning_job, inConditionslist);
            inConditionslist.add(new_dep);
        } else if (!inConditionslist.containsCondition(new_dep)) {
            inConditionslist.add(new_dep);
        }
    }

    public JobDepList getJobDependencies(int jobid) {
        return this.m_inConds.get(jobid);
    }

    public JobDepList getOutDeps(int jobid) {
        return this.m_outConds.get(jobid);
    }

    static {
        conditionNameMaker = null;
        m_instance = null;
    }
}

