/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.cognos.CognosWrapper;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.tidal.AbstractTidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CognosConverter
extends AbstractTidalCmConvertor {
    private final CognosWrapper wrapper;
    private final TidalJob job;
    private static final Pattern SEARCH_PATH_FOLDER_PARTS = Pattern.compile("@name='([^']+)'");

    public CognosConverter(TidalJob job) {
        this.job = job;
        this.wrapper = new CognosWrapper((SchedEntity)job);
    }

    @Override
    public void convertCmValues(IAttrHolder jobDtlRecord) {
        XmlElement adapterXml = XmlLoader.from((String)jobDtlRecord.getAttr("JOBDTL_EXTINFO"));
        this.wrapper.convertDefaults().setConnectionProfile("DEFAULT_CONNECTION").setSearchPath(this.translateVariablesToControlM(this.getSearchPathFrom(adapterXml))).setBurstResport("N").setSelectedFormats(this.getSelectedFormatFrom(adapterXml)).setLocation(this.translateVariablesToControlM(this.getLocationFrom(adapterXml)));
        this.convertVariables(this.job, adapterXml);
    }

    private String getLocationFrom(XmlElement adapterXml) {
        return CognosConverter.getVariableFrom(adapterXml, "savelocal").orElse("");
    }

    private void convertVariables(TidalJob job, XmlElement adapterXml) {
        List.of("eaddr", "subject", "printer", "body").forEach(variableName -> CognosConverter.getVariableFrom(adapterXml, variableName).ifPresent(value -> job.addVariable("%%" + variableName, this.translateVariablesToControlM((String)value))));
    }

    private static Optional<String> getVariableFrom(XmlElement adapterXml, String elementName) {
        return Optional.ofNullable(adapterXml.getFirstChildElementByName(elementName)).flatMap(x -> Optional.ofNullable(x.getFirstChildElementByName("var.compound"))).map(XmlElement::getValue).filter(s -> !s.isBlank());
    }

    private String getSelectedFormatFrom(XmlElement adapterXml) {
        return adapterXml.getValueOfFirstChildElementByName("format");
    }

    private String escapeConcatenationCharacterIfNeeded(String value) {
        String hasVariableDeceleration = ".*?<.+>.*?";
        if (value.matches(hasVariableDeceleration)) {
            return value.replace(".", "..");
        }
        return value;
    }

    private String translateVariablesToControlM(String value) {
        return this.escapeConcatenationCharacterIfNeeded(value).replace("<", "%%").replace(">", ".");
    }

    private String getSearchPathFrom(XmlElement xml) {
        String cmd = xml.getValueOfFirstChildElementByName("cmd");
        Object cmdPrefix = cmd.isBlank() ? "" : "/" + cmd;
        String folderValue = xml.getValueOfFirstChildElementByName("folder");
        Matcher matcher = SEARCH_PATH_FOLDER_PARTS.matcher(folderValue);
        return matcher.results().map(r -> r.group(1)).collect(Collectors.joining("/", "/", (CharSequence)cmdPrefix));
    }
}

