/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.tidal.TidalJob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class CalcTimeFromTo {
    private String timeValue;
    private final IAttrHolder jobdtlRecord;
    private final TidalJob parent;
    private final ArrayList<String> messages;
    private final String jobName4Report;
    private final String origJobName;
    private final String jobName;
    private static final SimpleDateFormat TIDAL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private static final DateTimeFormatter TIDAL_SHORT_TIME_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");
    private static final SimpleDateFormat SHORT_TIME_FORMAT = new SimpleDateFormat("HHmmss");

    public CalcTimeFromTo(String timeFrom, IAttrHolder jobdtlRecord, TidalJob parent, ArrayList<String> messages, String jobName4Report, String origJobName, String jobName) {
        this.timeValue = Optional.ofNullable(timeFrom).orElse("");
        this.jobdtlRecord = jobdtlRecord;
        this.parent = parent;
        this.messages = messages;
        this.jobName4Report = jobName4Report;
        this.origJobName = origJobName;
        this.jobName = jobName;
    }

    public String getTimeFrom() {
        Supplier<String> parentTimeFromGetter = () -> Optional.ofNullable(this.parent).map(TidalJob::getTimeFrom).orElse("");
        return this.getTimeValue("JOBDTL_FROMTM", parentTimeFromGetter, "INF2023", "WRN2341");
    }

    public String getTimeTo() {
        Supplier<String> parentTimeToGetter = () -> Optional.ofNullable(this.parent).map(TidalJob::getTimeTo).orElse("");
        return this.getTimeValue("JOBDTL_UNTILTM", parentTimeToGetter, "INF2024", "WRN2342");
    }

    private String getTimeValue(String jobdtlTimeAttribute, Supplier<String> parentTimeValue, String missingParentTimeValueMessage, String timeFormatNotValidMessage) {
        String jobDtlTimeToValue = this.jobdtlRecord.getAttr(jobdtlTimeAttribute);
        if (this.timeValue.isEmpty()) {
            if (this.hasParent()) {
                this.timeValue = this.shouldInheritTimeFromParent() ? this.getParentTimeValue(parentTimeValue.get(), missingParentTimeValueMessage) : this.getJobTimeValue(jobDtlTimeToValue, timeFormatNotValidMessage).orElse(parentTimeValue.get());
            } else {
                Optional<String> jobTimeValue = this.getJobTimeValue(jobDtlTimeToValue, timeFormatNotValidMessage);
                this.timeValue = jobTimeValue.orElse("");
            }
        }
        return this.timeValue;
    }

    private String getParentTimeValue(String parentTimeValue, String missingParentValueMessage) {
        if (parentTimeValue != null && !parentTimeValue.isEmpty()) {
            return parentTimeValue;
        }
        Reporter.addMessage(this.messages, (String)missingParentValueMessage, (String)this.jobName4Report, (String[])new String[]{this.origJobName});
        return "";
    }

    private boolean shouldInheritTimeFromParent() {
        return Optional.ofNullable(this.jobdtlRecord.getAttr("JOBDTL_INHTIME")).map("Y"::equalsIgnoreCase).orElse(false);
    }

    private boolean hasParent() {
        return this.parent != null;
    }

    private Optional<String> getJobTimeValue(String jobDtlToTime, String timeValueNotValidMessage) {
        Optional<String> jobTimeValue = Optional.ofNullable(jobDtlToTime).filter(s -> !s.isEmpty()).flatMap(timeValue -> CalcTimeFromTo.tryParseEpochDateTime(timeValue).or(() -> this.tryParseTidalDateFormat((String)timeValue)).or(() -> this.tryParseShortTidalDateFormat((String)timeValue)));
        if (jobTimeValue.isEmpty()) {
            Reporter.addMessage(this.messages, (String)timeValueNotValidMessage, (String)this.jobName4Report, (String[])new String[]{this.origJobName, this.jobName, this.timeValue});
        }
        return jobTimeValue;
    }

    private Optional<String> tryParseTidalDateFormat(String timeValue) {
        try {
            Date date = TIDAL_DATE_FORMAT.parse(timeValue);
            return Optional.of(SHORT_TIME_FORMAT.format(date).substring(0, 4));
        }
        catch (ParseException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return Optional.empty();
        }
    }

    private Optional<String> tryParseShortTidalDateFormat(String timeValue) {
        try {
            LocalDateTime date = LocalDateTime.parse(timeValue, TIDAL_SHORT_TIME_FORMAT);
            String hour = CalcTimeFromTo.pad(date.getHour());
            String minute = CalcTimeFromTo.pad(date.getMinute());
            return Optional.of(hour + minute);
        }
        catch (DateTimeParseException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return Optional.empty();
        }
    }

    private static String pad(int value) {
        return String.format("%02d", value);
    }

    static Optional<String> tryParseEpochDateTime(String dateTimeValue) {
        Function<String, Optional> toDecimal = s -> {
            try {
                return Optional.of(Double.valueOf(s));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        };
        Predicate<String> isEpochTimeFormat = s -> s.matches("\\d+(\\.)?\\d*");
        UnaryOperator takeDecimalTimePart = s -> s.contains(".") ? s.substring(s.indexOf(".")) : "0";
        UnaryOperator toSeconds = d -> d * 24.0 * 60.0 * 60.0;
        return Optional.ofNullable(dateTimeValue).filter(isEpochTimeFormat).map(takeDecimalTimePart).flatMap(toDecimal).map(toSeconds).map(Math::round).map(LocalTime::ofSecondOfDay).map(dt -> {
            String hours = CalcTimeFromTo.pad(dt.getHour());
            String minutes = CalcTimeFromTo.pad(dt.getMinute());
            return hours + minutes;
        });
    }
}

