/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.TidalCmConvertor;
import com.bmc.ctmconvert.tidal.TidalJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTidalCmConvertor
implements TidalCmConvertor {
    protected String applForm;
    protected String applVer;
    protected String applType;
    protected String cmVer;
    protected LinkedHashMap<String, String> autoeditToValue = new LinkedHashMap();
    private Map<String, List<String[]>> msgIdToMsgArgs = new HashMap<String, List<String[]>>();

    @Override
    public abstract void convertCmValues(IAttrHolder var1);

    protected void registerMessage(String msgId, String ... msgArgs) {
        if (!this.msgIdToMsgArgs.containsKey(msgId)) {
            this.msgIdToMsgArgs.put(msgId, new ArrayList());
        }
        this.msgIdToMsgArgs.get(msgId).add(msgArgs);
    }

    @Override
    public void convert(TidalJob tidalJob) {
        this.addAttributes(tidalJob);
        this.addVariables(tidalJob);
        this.addCmAllMessages(tidalJob);
    }

    protected void addAttributes(TidalJob tidalJob) {
        if (this.cmVer != null) {
            tidalJob.setAttribute("CM_VER", this.cmVer);
        }
        if (this.applVer != null) {
            tidalJob.setAttribute("APPL_VER", this.applVer);
        }
        if (this.applForm != null) {
            tidalJob.setAttribute("APPL_FORM", this.applForm);
        }
        if (this.applType != null) {
            tidalJob.setAttribute("APPL_TYPE", this.applType);
        }
    }

    protected void addVariables(TidalJob tidalJob) {
        for (String varName : this.autoeditToValue.keySet()) {
            tidalJob.addVariable(varName, this.autoeditToValue.get(varName));
        }
    }

    protected void addCmAllMessages(TidalJob tidalJob) {
        for (String msgId : this.msgIdToMsgArgs.keySet()) {
            for (String[] args : this.msgIdToMsgArgs.get(msgId)) {
                args = this.addJobNamesToMessageArgumens(tidalJob, args);
                tidalJob.addMessage(msgId, args);
            }
        }
    }

    private String[] addJobNamesToMessageArgumens(TidalJob tidalJob, String[] args) {
        ArrayList<String> temp = new ArrayList<String>(Arrays.asList(args));
        temp.add(tidalJob.getJobName());
        temp.add(tidalJob.getOriginalJobName());
        args = temp.toArray(new String[0]);
        return args;
    }
}

