/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.TidalDefData;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DefaultDataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.FirstDayOfTheWeekRule;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.tidal.SourceDataTidal;
import com.bmc.ctmconvert.tidal.TidalDefs;
import com.bmc.ctmconvert.tidal.dataimport.autofiledetect.TidalTableEntryDetector;
import java.io.InputStream;
import java.nio.file.Paths;

public class AppData
implements VendorData {
    public String getName() {
        return "TIDAL";
    }

    public String getDisplayName() {
        return "Tidal Software\u00ae Enterprise Scheduler";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return null;
    }

    public DataForImportDetector getDataForImportDetector() {
        return new DefaultDataForImportDetector((DetectFileForEntry)new TidalTableEntryDetector());
    }

    public BasePanel getAssessmentReport(String path) {
        return new SourceDataTidal(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML);
    }

    public CliImporter getCLIImporter() {
        return null;
    }

    public ImportEntryList getImportEntries() {
        ImportEntryList importEntries = super.getImportEntries();
        importEntries.sort();
        return importEntries;
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) {
        String datasourcePath = String.valueOf(Paths.get(Params.instance().getDatasourcePath(), new String[0])) + Globs.DIRSEP;
        TidalDefData tidalDefData = new TidalDefData(datasourcePath);
        return new TidalDefs(RuleManager.instance().getCurrentRules(), tidalDefData.getIndipendentJobmstInputStream(), tidalDefData.getDataSource(), tidalDefData.getInputStream("JOBDEP"));
    }

    public InputStream getRulesResourceFile() {
        InputStream fileStream = AppData.class.getResourceAsStream("/rules.xml");
        return fileStream;
    }

    public boolean isZOS() {
        return false;
    }

    public String getHelpTitle(boolean isAutomatic) {
        if (isAutomatic) {
            return "LOAD_DATA_TIDAL_AUTOMATIC";
        }
        return "LOAD_DATA_TIDAL_MANUAL";
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return FirstDayOfTheWeekRule.getFirstDayOfTheWeek((String)"Additional Tidal rules", (String)"FIRST_DAY_OF_WEEK");
    }
}

