/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import com.bmc.toolbox.compare.xml_compare.XmlElement;
import com.bmc.toolbox.compare.xml_compare.XmlLoader;
import com.bmc.toolbox.xml_json_compare.InputFile;
import com.bmc.toolbox.xml_json_compare.Mappers;
import com.bmc.toolbox.xml_json_compare.Structure;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class XmlStructure
implements Structure {
    public static final String JOBNAME = "JOBNAME";
    public static final String DEFTABLE = "DEFTABLE";
    private final XmlElement xmlElement;
    private final Mappers mappers;

    public XmlStructure(InputFile xmlDraft, Mappers mappers) {
        this(XmlStructure.getXmlElement(xmlDraft), mappers);
    }

    public XmlStructure(XmlElement xmlElement, Mappers mappers) {
        this.xmlElement = xmlElement;
        this.mappers = mappers;
    }

    private static XmlElement getXmlElement(InputFile xmlDraft) {
        try {
            XmlLoader loader = new XmlLoader(new LinkedHashMap<String, String>());
            loader.loadFile(xmlDraft.getInputStream());
            return loader.getElement();
        }
        catch (Exception e) {
            throw new XmlStructureException(e.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.xmlElement.getAttribute(JOBNAME);
    }

    @Override
    public String getType() {
        return this.xmlElement.getTagName();
    }

    @Override
    public Optional<Structure> getParent() {
        return Optional.empty();
    }

    @Override
    public List<Pair<String, String>> getAttributes() {
        if (this.xmlElement.getTagName().equals(DEFTABLE)) {
            return Collections.emptyList();
        }
        return this.xmlElement.getAttributes().stream().map(attr -> new ImmutablePair(attr, (Object)this.xmlElement.getAttribute((String)attr))).collect(Collectors.toList());
    }

    @Override
    public List<Structure> getChildren() {
        return this.getFolders().stream().map(element -> new XmlStructure((XmlElement)element, this.mappers)).collect(Collectors.toList());
    }

    @Override
    public Predicate<String> getFilter() {
        return this.mappers.getFilterFor(Mappers.TARGET.XML);
    }

    @Override
    public Function<String, String> getMapper() {
        return this.mappers.getMapperFor(Mappers.TARGET.XML);
    }

    private List<XmlElement> getFolders() {
        if (this.xmlElement.getTagName().equals(DEFTABLE)) {
            return this.xmlElement.getAllDescendantElementsByName("SMART_FOLDER");
        }
        return this.xmlElement.getAllDirectchildsElement();
    }

    public String toString() {
        return this.getName();
    }

    public static class XmlStructureException
    extends RuntimeException {
        public XmlStructureException(String message) {
            super(message);
        }
    }
}

