/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.xml_json_compare;

import com.bmc.toolbox.ToolBoxCLIEntity;
import com.bmc.toolbox.xml_json_compare.Changes;
import com.bmc.toolbox.xml_json_compare.InputFile;
import com.bmc.toolbox.xml_json_compare.JsonStructure;
import com.bmc.toolbox.xml_json_compare.Mappers;
import com.bmc.toolbox.xml_json_compare.StructureCompare;
import com.bmc.toolbox.xml_json_compare.XmlStructure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JsonXmlCompareTool
implements ToolBoxCLIEntity {
    private final List<String> errorMessages = new ArrayList<String>();
    private final int returnCode;
    private InputFile jsonFile;
    private InputFile xmlFile;
    private Mappers mappers;
    private String output = "";

    public JsonXmlCompareTool() {
        this.returnCode = 0;
    }

    @Override
    public void execute(String ... args) {
        try {
            JsonStructure json = new JsonStructure(this.jsonFile, this.mappers);
            XmlStructure xml = new XmlStructure(this.xmlFile, this.mappers);
            StructureCompare compare = new StructureCompare(json, xml);
            Changes result = compare.compare();
            this.output = result.toString();
        }
        catch (Exception e) {
            this.errorMessages.add(e.getMessage());
        }
    }

    @Override
    public boolean validate(String ... arguments) {
        if (arguments.length > 1) {
            this.jsonFile = new InputFile(arguments[0]);
            this.xmlFile = new InputFile(arguments[1]);
            this.mappers = this.initMappers(arguments);
            return true;
        }
        return false;
    }

    private Mappers initMappers(String[] arguments) {
        String filePath = this.getMappersFilePath(arguments);
        return new Mappers(new InputFile(filePath));
    }

    private String getMappersFilePath(String[] arguments) {
        String filePath = arguments.length > 2 ? arguments[2] : new File(Objects.requireNonNull(this.getClass().getClassLoader().getResource("mappers.json")).getFile()).getAbsolutePath();
        return filePath;
    }

    @Override
    public String getUsage() {
        return "JSON_XML_COMPARE USAGE :\n\tJSON_XML_COMPARE <JSON_FILE> <XML_FILE> [MAPPING_FILE.json]";
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public int getRC() {
        return this.returnCode;
    }

    @Override
    public String getValidationErrors() {
        return String.join((CharSequence)"\n", this.errorMessages);
    }
}

