/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare;

import com.bmc.toolbox.compare.xml_compare.XmlCompare;
import com.bmc.toolbox.compare.xml_compare.changes.XmlChange;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class XMLChangesCsvWriter
implements XmlCompare.ChangeHandelr,
AutoCloseable {
    boolean isSuccedd = true;
    private CsvWriter writer;
    private Initilizer initilizer;
    private boolean isChangeOccured = false;

    public XMLChangesCsvWriter(File outputFile) throws IOException {
        this.initilizer = () -> {
            FileWriter fileWriter = new FileWriter(outputFile);
            this.init(fileWriter);
        };
    }

    public XMLChangesCsvWriter(Writer writer) throws IOException {
        this.initilizer = () -> this.init(writer);
    }

    @Override
    public void handleChange(XmlChange change) {
        try {
            if (this.firstTime()) {
                this.initilizer.initilize();
                this.writeHeaders();
            }
            this.writeChangeToFile(change);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private void init(Writer fileWriter) throws IOException {
        this.writer = new CsvWriter(fileWriter, ',');
    }

    private boolean firstTime() {
        if (!this.isChangeOccured) {
            this.isChangeOccured = true;
            return true;
        }
        return false;
    }

    private void writeHeaders() throws IOException {
        String[] headers = new String[]{"FULL_PATH", "ACTION", "NODE_TYPE", "NODE_NAME", "NODE_IDENTIFY", "PATH_1", "PATH_2", "PATH_3", "PATH_4", "PATH_5", "PATH_6"};
        this.writer.writeRecord(headers);
    }

    private void writeChangeToFile(XmlChange change) throws IOException {
        XmlChange.Action action = change.getAction();
        String currentPath = change.getPath();
        String nodeName = change.getName();
        XmlChange.Type nodeType = change.getChaneType();
        List<String> parentPath = change.getParentPathList();
        String nodeIdentify = change.getIdentifier();
        this.writeParamsToFile(this.writer, currentPath, nodeName, nodeType, nodeIdentify, parentPath, action);
    }

    private void writeParamsToFile(CsvWriter writer, String currentPath, String name, XmlChange.Type xmlType, String nodeIdentify, List<String> parentPath, XmlChange.Action action) throws IOException {
        ArrayList<String> record = new ArrayList<String>();
        record.add(currentPath);
        record.add(action.toString());
        record.add(xmlType.toString());
        record.add(name);
        record.add(nodeIdentify);
        record.addAll(parentPath);
        writer.writeRecord(record.toArray(new String[record.size()]));
        writer.flush();
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @FunctionalInterface
    public static interface Initilizer {
        public void initilize() throws IOException;
    }
}

