/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare;

import com.bmc.toolbox.compare.xml_compare.XMLAttributeChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AttributesComperator {
    private Collection<String> intersection;
    private Map<String, String> attributes1;
    private Map<String, String> attributes2;

    public AttributesComperator(Map<String, String> attributes1, Map<String, String> attributes2) {
        this.attributes1 = attributes1;
        this.attributes2 = attributes2;
        this.intersection = new HashSet<String>(attributes1.keySet());
        this.intersection.retainAll(attributes2.keySet());
    }

    public Map<String, String> getOnlyOn1() {
        Map<String, String> onlyOn1attributes = this.getOnlyOn(this.attributes1);
        return onlyOn1attributes;
    }

    public Map<String, String> getOnlyOn2() {
        Map<String, String> onlyOn2attributes = this.getOnlyOn(this.attributes2);
        return onlyOn2attributes;
    }

    private Map<String, String> getOnlyOn(Map<String, String> attributes) {
        HashSet<String> onlyOn = new HashSet<String>(attributes.keySet());
        onlyOn.removeAll(this.intersection);
        Map<String, String> onlyOnattributes = onlyOn.stream().collect(Collectors.toMap(Function.identity(), attr -> (String)attributes.get(attr)));
        return onlyOnattributes;
    }

    public List<XMLAttributeChange> getAttributeChanges() {
        ArrayList<XMLAttributeChange> ret = new ArrayList<XMLAttributeChange>();
        for (String attributeName : this.intersection) {
            String attr2Value;
            String attr1Value = this.attributes1.get(attributeName);
            if (attr1Value.equals(attr2Value = this.attributes2.get(attributeName)) || attributeName.equals("DESCRIPTION") && attr2Value.startsWith(attr1Value)) continue;
            XMLAttributeChange attrChange = new XMLAttributeChange(attributeName);
            attrChange.setFirstValue(attr1Value);
            attrChange.setSecondValue(attr2Value);
            ret.add(attrChange);
        }
        return ret;
    }
}

