/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.properties_compare;

import com.bmc.toolbox.ToolBoxCLIEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;

public class ComparePropertiesFiles
implements ToolBoxCLIEntity {
    private String errorMessage;
    private int RC = 0;
    private static final int ERR = -1;
    private List<String> StdOut = new ArrayList<String>();
    private Properties prop1;
    private Properties prop2;

    @Override
    public void execute(String ... args) {
        try {
            FileInputStream in1 = new FileInputStream(args[0]);
            FileInputStream in2 = new FileInputStream(args[1]);
            this.prop1 = new Properties();
            this.prop2 = new Properties();
            this.prop1.load(in1);
            this.prop2.load(in2);
        }
        catch (IOException e) {
            this.StdOut.add(e.getMessage());
            this.RC = -1;
        }
        if (!this.compare()) {
            this.StdOut.add("There is no changes between these two files");
        }
    }

    public boolean compare() {
        LinkedHashSet<String> allKeysSet = new LinkedHashSet<String>();
        boolean haveChanges = false;
        for (String name : this.prop1.stringPropertyNames()) {
            allKeysSet.add(name);
        }
        for (String name : this.prop2.stringPropertyNames()) {
            allKeysSet.add(name);
        }
        for (String propertyKey : allKeysSet) {
            String value1 = this.prop1.getProperty(propertyKey);
            String value2 = this.prop2.getProperty(propertyKey);
            if (value1 == null && value2 != null) {
                this.StdOut.add("Property: " + propertyKey + " is Added to file2");
                haveChanges = true;
                continue;
            }
            if (value2 == null && value1 != null) {
                this.StdOut.add("Property: " + propertyKey + " is Removed from file1");
                haveChanges = true;
                continue;
            }
            if (value2 == null && value1 == null) {
                this.StdOut.add("we should never get here!!!");
                haveChanges = true;
                continue;
            }
            if (value1.equals(value2)) continue;
            this.StdOut.add("The value of property: " + propertyKey + " has been changed from: " + value1 + " to: " + value2);
            haveChanges = true;
        }
        return haveChanges;
    }

    @Override
    public boolean validate(String ... args) {
        boolean isValid = true;
        if (args.length != 2) {
            this.errorMessage = this.errorMessage + "\nWrong arguments number.\nNeed to be only 2.";
            isValid = false;
            this.RC = -1;
        } else {
            for (String arg : args) {
                if (new File(arg).isFile()) continue;
                this.errorMessage = this.errorMessage + "\nFile not found: " + arg;
                isValid = false;
                this.RC = -1;
            }
        }
        return isValid;
    }

    @Override
    public String getUsage() {
        return "USAGE : ComparePropertiesFiles <File_1> <File_2>";
    }

    private String ListToString(List<String> strList) {
        StringBuilder toRet = new StringBuilder();
        if (strList != null && !strList.isEmpty()) {
            for (String str : strList) {
                toRet.append(str).append('\n');
            }
        }
        return toRet.toString();
    }

    @Override
    public String getOutput() {
        return this.ListToString(this.StdOut);
    }

    public int getSizeOfStdOut() {
        return this.StdOut.size();
    }

    @Override
    public int getRC() {
        return this.RC;
    }

    @Override
    public String getValidationErrors() {
        return this.errorMessage;
    }

    public Properties getProp1() {
        return this.prop1;
    }

    public void setProp1(Properties prop1) {
        this.prop1 = prop1;
    }

    public Properties getProp2() {
        return this.prop2;
    }

    public void setProp2(Properties prop2) {
        this.prop2 = prop2;
    }
}

