/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArgsHandler {
    private static final String[] argKeys = new String[]{"-old", "-new", "-out", "-keys", "-ignore", "-ordered"};
    private static final int[] mandatoryKeysIdx = new int[]{0, 1};
    private static final int[] singleValueKeysIdx = new int[]{0, 1, 2, 5};
    private static final int[] expectedFilesidx = new int[]{0, 1};
    private static final int[] booleanFieldsidx = new int[]{5};
    public static final String unexpectedArgHead = "Unexpected command line argument";
    private static final String unexpectedArgFormat = "%s <%s>";
    public static final String missingMandatoryHead = "Missing mandatory argument";
    private static final String missingMandatoryFormat = "%s %s for '%s'";
    public static final String fileNotFoundHead = "File not found.";
    private static final String fileNotFoundFormat = "%s '%s' provided as '%s' not found";
    public static final String noValueHead = "No value provided for arg";
    private static final String noValueFormat = "%s '%s'.";
    public static final String tooManyValuesHead = "Multiple values";
    private static final String tooManyValuesFormat = "%s (%s) provided for <%s>. Single value expected";
    public static final String invalidValueHead = "Invalid value";
    private static final String invalidValueFormat = "%s for <%s>. Expected %s";

    public static List<String> getValidationErrs(Map<String, List<String>> argsMap) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        validationErrors.addAll(ArgsHandler.checkKeyValidity(argsMap));
        validationErrors.addAll(ArgsHandler.checkMandatory(argsMap));
        validationErrors.addAll(ArgsHandler.checkInputFilesExist(argsMap));
        validationErrors.addAll(ArgsHandler.checkValueCount(argsMap));
        validationErrors.addAll(ArgsHandler.checkBooleanValueValidty(argsMap));
        return validationErrors;
    }

    private static List<String> checkKeyValidity(Map<String, List<String>> argsMap) {
        ArrayList<String> toRet = new ArrayList<String>();
        for (String suspectKey : argsMap.keySet()) {
            if (ArgsHandler.isKey(suspectKey)) continue;
            toRet.add(String.format(unexpectedArgFormat, unexpectedArgHead, suspectKey));
        }
        return toRet;
    }

    private static List<String> checkMandatory(Map<String, List<String>> argsMap) {
        ArrayList<String> toRet = new ArrayList<String>();
        for (int i = 0; i < mandatoryKeysIdx.length; ++i) {
            String mandtoryKey = argKeys[mandatoryKeysIdx[i]];
            List<String> tmpList = argsMap.get(mandtoryKey);
            if (tmpList != null && !tmpList.isEmpty()) continue;
            toRet.add(String.format(missingMandatoryFormat, missingMandatoryHead, argsMap.keySet().contains(mandtoryKey) ? "key" : "value", mandtoryKey));
        }
        return toRet;
    }

    private static List<String> checkInputFilesExist(Map<String, List<String>> argsMap) {
        ArrayList<String> toRet = new ArrayList<String>();
        for (int i = 0; i < expectedFilesidx.length; ++i) {
            String fileKey = argKeys[expectedFilesidx[i]];
            List<String> tmpList = argsMap.get(fileKey);
            if (tmpList == null) continue;
            for (String fileName : tmpList) {
                if (new File(fileName).isFile()) continue;
                toRet.add(String.format(fileNotFoundFormat, fileNotFoundHead, fileName, fileKey));
            }
        }
        return toRet;
    }

    private static List<String> checkValueCount(Map<String, List<String>> argsMap) {
        ArrayList<String> toRet = new ArrayList<String>();
        for (String key : argsMap.keySet()) {
            if (!ArgsHandler.isKey(key)) continue;
            if (argsMap.get(key) == null || argsMap.get(key).isEmpty()) {
                toRet.add(String.format(noValueFormat, noValueHead, key));
                continue;
            }
            if (argsMap.get(key).size() <= 1 || !ArgsHandler.isSingleValueKey(key)) continue;
            toRet.add(String.format(tooManyValuesFormat, tooManyValuesHead, argsMap.get(key).toString(), key));
        }
        return toRet;
    }

    private static List<String> checkBooleanValueValidty(Map<String, List<String>> argsMap) {
        ArrayList<String> toRet = new ArrayList<String>();
        for (int i = 0; i < booleanFieldsidx.length; ++i) {
            String booleanKey = argKeys[booleanFieldsidx[i]];
            List<String> suspectVal = argsMap.get(booleanKey);
            if (suspectVal == null || suspectVal.size() != 1 || suspectVal.get(0).matches("[YyNn]")) continue;
            toRet.add(String.format(invalidValueFormat, invalidValueHead, booleanKey, "{Y|N}"));
        }
        return toRet;
    }

    public static boolean isSingleValueKey(String currentKey) {
        boolean toRet = false;
        for (int i = 0; i < singleValueKeysIdx.length; ++i) {
            toRet = toRet || argKeys[singleValueKeysIdx[i]].equals(currentKey);
        }
        return toRet;
    }

    public static boolean isKey(String suspect) {
        int foundIndex;
        for (foundIndex = 0; foundIndex < argKeys.length && !suspect.equals(argKeys[foundIndex]); ++foundIndex) {
        }
        return foundIndex < argKeys.length;
    }

    public static HashMap<String, List<String>> mapArgs(String[] args) {
        HashMap<String, List<String>> argsMap = new HashMap<String, List<String>>();
        String currentKey = "";
        for (int i = 0; i < args.length; ++i) {
            if (ArgsHandler.isKey(args[i]) || currentKey.isEmpty()) {
                currentKey = args[i];
                argsMap.put(currentKey, new ArrayList());
                continue;
            }
            argsMap.get(currentKey).add(args[i]);
            if (!ArgsHandler.isSingleValueKey(currentKey)) continue;
            currentKey = "";
        }
        return argsMap;
    }
}

