/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.entitesCounter;

import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.EntitisMatcher;
import com.bmc.toolbox.compare.condition_compare.entitesCounter.SimpleDraftReader;
import com.bmc.toolbox.compare.condition_compare.entitesCounter.changeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class EntitesCounterComperator {
    private changeHandler changeHandler;

    public EntitesCounterComperator(changeHandler changeHandler2) {
        this.changeHandler = changeHandler2;
    }

    public void compare(InputStream inA, InputStream inB) throws IOException {
        List<DraftEntityImp> entites1 = SimpleDraftReader.getEntities(inA);
        List<DraftEntityImp> entites2 = SimpleDraftReader.getEntities(inB);
        this.compare(entites1, entites2);
    }

    public void compare(List<DraftEntityImp> entites1, List<DraftEntityImp> entites2) {
        this.checkEntites(entites1, entites2);
    }

    private void checkEntites(List<DraftEntityImp> entites1, List<DraftEntityImp> entites2) {
        if (entites1.size() != entites2.size()) {
            this.changeHandler.addEvent(entites1.size(), entites2.size());
        }
        EntitisMatcher matcher = new EntitisMatcher(entites1, entites2);
        for (DraftEntityImp entity : entites1) {
            if (matcher.isOnSecond(entity)) continue;
            this.changeHandler.addExistOnlyINFirstEvent(entity.getPath());
        }
        for (DraftEntityImp entity : entites2) {
            DraftPath path = entity.getPath();
            if (matcher.isOnFirst(entity)) continue;
            this.changeHandler.addExistOnlyInSecondEvent(path);
        }
    }

    public static class ChangeHandler
    implements changeHandler {
        @Override
        public void addEvent(int size1, int size2) {
            System.out.println("draft does not have same number of Entities." + size1 + ":" + size2);
        }

        @Override
        public void addExistOnlyINFirstEvent(DraftPath path) {
            System.out.println("draft 2 does not have entity" + String.valueOf(path));
        }

        @Override
        public void addExistOnlyInSecondEvent(DraftPath path) {
            System.out.println("draft 1 does not have entity" + String.valueOf(path));
        }
    }
}

