/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.draftReader;

import com.bmc.toolbox.compare.condition_compare.draftReader.XmlLoader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlElement {
    private XmlLoader xmlLoader;
    private Element element;
    private XmlElement parent;
    private ArrayList<XmlElement> elementsPath;

    public XmlElement(XmlLoader xmlLoader, Element element) {
        this(xmlLoader, element, null);
    }

    protected XmlElement(XmlLoader xmlLoader, Element element, XmlElement parent) {
        this.xmlLoader = xmlLoader;
        this.element = element;
        this.parent = parent;
    }

    public List<XmlElement> getDirectchildsElementbyName(String ... ElementsTagName) {
        ArrayList<XmlElement> elementList = new ArrayList<XmlElement>();
        List<String> taglist = Arrays.asList(ElementsTagName);
        for (Node childNode = this.element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1 || !taglist.contains(((Element)childNode).getNodeName())) continue;
            elementList.add(new XmlElement(this.xmlLoader, (Element)childNode, this));
        }
        return elementList;
    }

    public List<XmlElement> getAllDirectchildsElement() {
        ArrayList<XmlElement> elementList = new ArrayList<XmlElement>();
        for (Node childNode = this.element.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            elementList.add(new XmlElement(this.xmlLoader, (Element)childNode, this));
        }
        return elementList;
    }

    public String getAttribute(String xmlAttrTitle) {
        return this.element.getAttribute(xmlAttrTitle);
    }

    public boolean hasAttribute(String xmlAttrTitle) {
        return this.element.hasAttribute(xmlAttrTitle);
    }

    public boolean hasAttribute(String keyAttrName, String valueAttrName) {
        String attributeValue = this.element.getAttribute(keyAttrName);
        return attributeValue.equals(valueAttrName);
    }

    public boolean hasAttributeincluding(String keyAttrName, String valueAttrName) {
        String attributeValue = this.element.getAttribute(keyAttrName);
        return attributeValue.contains(valueAttrName);
    }

    public XmlElement getParent() {
        return this.parent;
    }

    public List<String> getDirectChildsElementAttrByName(String ElementTagName, String ElementAtrributeName) {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlElement> elementList = this.getDirectchildsElementbyName(ElementTagName);
        for (XmlElement xmlElement : elementList) {
            if (xmlElement.getAttribute(ElementAtrributeName).isEmpty()) continue;
            result.add(xmlElement.getAttribute(ElementAtrributeName));
        }
        return result;
    }

    public void appendChild(XmlElement child) {
        this.element.appendChild(child.getElement());
    }

    public Element getElement() {
        return this.element;
    }

    public XmlElement getFirstChildElementByName(String ElementTagName) {
        List<XmlElement> childElementList = this.getDirectchildsElementbyName(ElementTagName);
        if (!childElementList.isEmpty()) {
            return childElementList.get(0);
        }
        return null;
    }

    public boolean containsElement(String ElementTagName) {
        XmlElement element = this.getFirstChildElementByName(ElementTagName);
        return element != null;
    }

    public List<XmlElement> getAllDescendantElementsByName(String tagName) {
        return this.findAllElementsByNameDFS(tagName);
    }

    public boolean hasChild(String childTagName) {
        XmlElement child = this.getFirstChildElementByName(childTagName);
        return child != null;
    }

    public HashMap<String, String> getDirectChildsElementKeyValueAttrByName(String ElementTagName, String keyAttrName, String valueAttrName) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<XmlElement> elementList = this.getDirectchildsElementbyName(ElementTagName);
        for (XmlElement xmlElement : elementList) {
            String value;
            if (xmlElement.getAttribute(keyAttrName).isEmpty() || !valueAttrName.equals(value = xmlElement.getAttribute(keyAttrName))) continue;
            result.put(keyAttrName, value);
        }
        return result;
    }

    public HashMap<String, String> getDescendantChildsElementKeyValueAttrByName(String ElementTagName, String keyAttrName, String valueAttrName) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<XmlElement> elementList = this.getAllDescendantElementsByName(ElementTagName);
        for (XmlElement xmlElement : elementList) {
            String value;
            if (xmlElement.getAttribute(keyAttrName).isEmpty() || !valueAttrName.equals(value = xmlElement.getAttribute(keyAttrName))) continue;
            result.put(keyAttrName, value);
        }
        return result;
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getValue() {
        return this.element.getTextContent();
    }

    public String toString() {
        Transformer transformer = null;
        StreamResult result = new StreamResult(new StringWriter());
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.element);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String xmlString = result.getWriter().toString();
        return xmlString;
    }

    public XmlElement getFirstChildElementByAttrValue(String TagName, String AttrName, String AttrValue) {
        List<XmlElement> elementList = this.getDirectchildsElementbyName(TagName);
        for (XmlElement xmlElement : elementList) {
            if (!xmlElement.getAttribute(AttrName).equals(AttrValue)) continue;
            return xmlElement;
        }
        return null;
    }

    public List<String> getChildsTags() {
        List<XmlElement> childs = this.getAllDirectchildsElement();
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (XmlElement child : childs) {
            ret.put(child.getTagName(), "");
        }
        return new ArrayList<String>(ret.keySet());
    }

    public String getIdentifier() {
        if (!this.xmlLoader.TagAttrIdentetyMap.containsKey(this.getTagName())) {
            return null;
        }
        String identfierAttribute = this.xmlLoader.TagAttrIdentetyMap.get(this.getTagName());
        if (!this.hasAttribute(identfierAttribute)) {
            return null;
        }
        return this.getAttribute(identfierAttribute);
    }

    public List<String> getAttributes() {
        ArrayList<String> ret = new ArrayList<String>();
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.item(i) == null || !(attrs.item(i) instanceof Attr)) continue;
            Attr attribute = (Attr)attrs.item(i);
            ret.add(attribute.getName());
        }
        return ret;
    }

    public LinkedHashMap<String, String> getAttributesValues() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.item(i) == null || !(attrs.item(i) instanceof Attr)) continue;
            Attr attribute = (Attr)attrs.item(i);
            ret.put(attribute.getName(), attribute.getValue());
        }
        return ret;
    }

    public String getXPath() {
        if (this.parent == null) {
            return "/" + this.getTagName();
        }
        String id = this.getID();
        return String.valueOf(this.parent.getXPath()) + "/" + id;
    }

    public String getID() {
        String name = this.getTagName();
        String identifier = this.getIdentifier() != null ? "[@id='" + this.getIdentifier() + "']" : "";
        return String.valueOf(name) + identifier;
    }

    public List<XmlElement> getElementsPath() {
        if (this.elementsPath == null) {
            this.elementsPath = new ArrayList();
            if (this.parent != null) {
                this.elementsPath.addAll(this.parent.getElementsPath());
            }
            this.elementsPath.add(this);
        }
        return this.elementsPath;
    }

    public List<XmlElement> getDecnedElementByNameKeyAndValue(String elementTagName, String keyAttrName, String valueAttrName) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put(keyAttrName, valueAttrName);
        return this.getDecendentsWhichHaveAttributes(elementTagName, attributes);
    }

    public List<XmlElement> getDecendentsWhichHaveAttributes(String elementTagName, LinkedHashMap<String, String> attributes) {
        ArrayList<XmlElement> ret = new ArrayList<XmlElement>();
        List<XmlElement> allElements = this.getAllDescendantElementsByName(elementTagName);
        this.containsAtrributes(attributes, ret, allElements);
        return ret;
    }

    public List<XmlElement> getDecendentsWhichHaveEqualAttributes(String elementTagName, LinkedHashMap<String, String> attributes) {
        ArrayList<XmlElement> allElements = new ArrayList<XmlElement>(this.findAllElementsByNameDFS(elementTagName));
        return this.getAllequalAtrributes(attributes, allElements);
    }

    private void containsAtrributes(LinkedHashMap<String, String> attributes, List<XmlElement> ret, List<XmlElement> allElements) {
        for (XmlElement xmlElement : allElements) {
            if (!xmlElement.containsAllAttributes(attributes)) continue;
            ret.add(xmlElement);
        }
    }

    private List<XmlElement> getAllequalAtrributes(LinkedHashMap<String, String> attributes, ArrayList<XmlElement> allElements) {
        ArrayList<XmlElement> ret = new ArrayList<XmlElement>();
        for (XmlElement xmlElement : allElements) {
            if (!xmlElement.isEqualAttributes(attributes)) continue;
            ret.add(xmlElement);
        }
        return ret;
    }

    private boolean isEqualAttributes(LinkedHashMap<String, String> attributes) {
        return this.getAttributesValues().equals(attributes);
    }

    public boolean containsAllAttributes(LinkedHashMap<String, String> attributes) {
        boolean result = true;
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String value;
            String name = attribute.getKey();
            if (this.hasAttribute(name, value = attribute.getValue())) continue;
            result = false;
        }
        return result;
    }

    public boolean containsElement(XmlElement child) {
        LinkedHashMap<String, String> elementsAttributs = child.getAttributesValues();
        String tagName = child.getTagName();
        for (String xmlElementKey : elementsAttributs.keySet()) {
            String attributeValue;
            HashMap<String, String> elements = this.getDescendantChildsElementKeyValueAttrByName(tagName, xmlElementKey, attributeValue = child.getAttribute(xmlElementKey));
            if (!elements.isEmpty()) continue;
            return false;
        }
        for (XmlElement xmlElement : child.getAllDirectchildsElement()) {
            if (this.containsElement(xmlElement)) continue;
            return false;
        }
        return true;
    }

    public boolean isContainsExactlyTheSameElement(XmlElement child) {
        List<XmlElement> decendentsWhichHaveAttributes = this.getDecendentsWhichHaveEqualAttributes(child.getTagName(), child.getAttributesValues());
        return !decendentsWhichHaveAttributes.isEmpty();
    }

    public boolean doesElementContainElementWithAttributeValue(String elementName, String attrName, String attrValue) {
        boolean result = false;
        if (this.hasChild(elementName)) {
            for (XmlElement childWithElementName : this.findAllElementsByNameDFS(elementName)) {
                if (!childWithElementName.hasAttribute(attrName) || !childWithElementName.getAttribute(attrName).equalsIgnoreCase(attrValue)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private List<XmlElement> findAllElementsByNameDFS(String tagName) {
        ArrayList<XmlElement> retList = new ArrayList<XmlElement>();
        if (this.getTagName().equals(tagName)) {
            retList.add(this);
        }
        for (XmlElement child : this.getAllDirectchildsElement()) {
            retList.addAll(child.findAllElementsByNameDFS(tagName));
        }
        return retList;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public XmlLoader getXmlLoader() {
        return this.xmlLoader;
    }
}

