/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.draftReader;

import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.draftReader.DraftEntitiesReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.EndReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderUtils;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfElementPredicate;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ConditionReader
implements DraftEntitiesReader {
    private ConditionHandler conditionHandler;

    public ConditionReader(ConditionHandler conditionAdder) {
        this.conditionHandler = conditionAdder;
    }

    @Override
    public void read(XMLEventReader eventReader) throws XMLStreamException {
        List<MyAttribute> newAttributes;
        XMLEvent event = eventReader.peek();
        if (this.isStartOfOutConditionEvent(event)) {
            XMLEvent outConditionsEvent = eventReader.nextEvent();
            newAttributes = ReaderUtils.getEventAttributes(outConditionsEvent);
            String outConditionName = this.getName(newAttributes);
            this.conditionHandler.addOutCondition(outConditionName);
            String outcondtagName = "OUTCOND";
            EndReader.readEnd(outcondtagName, eventReader);
        }
        if (this.isStartOfInConditionEvent(event)) {
            XMLEvent inConditionsEvent = eventReader.nextEvent();
            newAttributes = ReaderUtils.getEventAttributes(inConditionsEvent);
            String InconditionName = this.getName(newAttributes);
            this.conditionHandler.addInCondition(InconditionName);
            String incondtagName = "INCOND";
            EndReader.readEnd(incondtagName, eventReader);
        }
    }

    private boolean isStartOfOutConditionEvent(XMLEvent event) {
        String tagName = "OUTCOND";
        StartOfElementPredicate startOfElementPredicate = new StartOfElementPredicate(tagName);
        return startOfElementPredicate.test(event);
    }

    private boolean isStartOfInConditionEvent(XMLEvent event) {
        String tagName = "INCOND";
        StartOfElementPredicate startOfElementPredicate = new StartOfElementPredicate(tagName);
        return startOfElementPredicate.test(event);
    }

    private String getName(List<MyAttribute> myAttributes) {
        ValueGetter nameGetter = new ValueGetter("NAME");
        String smartFolderName = nameGetter.fromList(myAttributes);
        return smartFolderName;
    }

    public static interface ConditionHandler {
        public void addInCondition(String var1);

        public void addOutCondition(String var1);
    }
}

