/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.CD_DataAnalysis;

import com.bmc.toolbox.CD_DataAnalysis.cdprocess;
import com.bmc.toolbox.ToolBoxCLIEntity;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class DataAnalysis
implements ToolBoxCLIEntity {
    private String errorMessage;
    private int RC = 0;
    private static final int ERR = -1;
    private List<String> StdOut = new ArrayList<String>();

    @Override
    public void execute(String ... args) {
        String dataFolder = args[0];
        String destinationCSV = args[1];
        String customerName = args[2];
        CsvWriter writer = new CsvWriter(destinationCSV);
        List<String> fields = Arrays.asList("customer", "filename", "process", "retain", "lable", "cmd", "param", "nStatmentLines", "nEmptyLines", "nCommentLines");
        for (String f : fields) {
            try {
                writer.write(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            writer.endRecord();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filename = "AMARAL";
        File folder = new File(dataFolder);
        if (folder != null) {
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory()) continue;
                filename = fileEntry.getName();
                Path path = FileSystems.getDefault().getPath(fileEntry.getPath(), new String[0]);
                String data = "";
                try {
                    data = new String(Files.readAllBytes(path), "Latin1");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                cdprocess process = new cdprocess();
                ArrayList<Properties> ret = process.analysis(data);
                for (Properties properties : ret) {
                    properties.setProperty("customer", customerName);
                    properties.setProperty("filename", filename);
                    for (String name : fields) {
                        try {
                            writer.write(properties.getProperty(name));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        writer.endRecord();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        writer.close();
    }

    @Override
    public boolean validate(String ... args) {
        boolean isValid = true;
        if (args.length != 3) {
            this.errorMessage = this.errorMessage + "\nWrong arguments number.\nNeed to be only 3.";
            isValid = false;
            this.RC = -1;
        } else {
            if (!new File(args[0]).isDirectory()) {
                this.errorMessage = this.errorMessage + "\nData directory not found: " + args[0];
                isValid = false;
                this.RC = -1;
            }
            if (!args[1].endsWith(".csv")) {
                this.errorMessage = this.errorMessage + "\nDestination file should end with .csv: " + args[1];
                isValid = false;
                this.RC = -1;
            }
        }
        return isValid;
    }

    @Override
    public String getUsage() {
        return "Usage: CD_DATA_ANALYSIS <Data folder name> <outputFileName.csv> <CustomerName>\n";
    }

    @Override
    public String getOutput() {
        return this.ListToString(this.StdOut);
    }

    @Override
    public int getRC() {
        return this.RC;
    }

    @Override
    public String getValidationErrors() {
        return this.errorMessage;
    }

    private String ListToString(List<String> strList) {
        StringBuilder toRet = new StringBuilder();
        if (strList != null && !strList.isEmpty()) {
            for (String str : strList) {
                toRet.append(str).append('\n');
            }
        }
        return toRet.toString();
    }
}

